package com.artfess.reform.fill.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.dao.BizMeetingEventDao;
import com.artfess.reform.fill.manager.BizMeetingEventDetailsUnitManager;
import com.artfess.reform.fill.manager.BizMeetingEventManager;
import com.artfess.reform.fill.manager.BizMeetingEventDetailsManager;
import com.artfess.reform.fill.manager.BizMeetingEventPushManager;
import com.artfess.reform.fill.model.BizMeetingEvent;
import com.artfess.reform.fill.model.BizMeetingEventDetails;
import com.artfess.reform.fill.model.BizMeetingEventDetailsUnit;
import com.artfess.reform.fill.model.BizMeetingEventPush;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:会议议定事项表 服务实现类
 * @Author: Rong Tao
 * @Date: 2023/4/3 16:50
 */
@Service
public class BizMeetingEventManagerImpl extends BaseManagerImpl<BizMeetingEventDao, BizMeetingEvent> implements BizMeetingEventManager {

    @Resource
    FileManager fileManager;
    @Resource
    private BizMeetingEventDetailsManager bizMeetingEventDetailsManager;
    @Resource
    private BizMeetingEventDetailsUnitManager bizMeetingEventDetailsUnitManager;
    @Resource
    private BizMeetingEventPushManager bizMeetingEventPushManager;

    @Override
    public PageList<BizMeetingEvent> queryByPage(QueryFilter<BizMeetingEvent> queryFilter) {
//        if(BizUtils.isAdmin(ucFeignService)) queryFilter.addFilter("ep.UNIT_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
//        queryFilter.addFilter("me.IS_DELE_","0", QueryOP.EQUAL);
//        queryFilter.addFilter("ep.IS_DELE_","0", QueryOP.EQUAL);
//        IPage<BizMeetingEvent> result = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()),
//                convert2Wrapper(queryFilter, currentModelClass()));

        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        PageList<BizMeetingEvent> result = super.query(queryFilter);
        return result;
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizMeetingEvent bizMeetingEvent) {
        List<BizMeetingEventDetails> bizMeetingEventDetailsList = bizMeetingEvent.getBizMeetingEventDetailsList();
        super.saveOrUpdate(bizMeetingEvent);

        List<DefaultFile> files = bizMeetingEvent.getFiles();
        if(null != files && files.size() > 0){
            List<String> fileList = files.stream().map(f -> f.getId()).collect(Collectors.toList());
            // 修改附件bizId
            fileManager.updateFileBizIdByIds(fileList, bizMeetingEvent.getId());
        }


        if(BeanUtils.isNotEmpty(bizMeetingEventDetailsList) && bizMeetingEventDetailsList.size()>0){
            bizMeetingEventDetailsList.stream().forEach(s->{
                s.setAbutmentStatus(1);
                s.setMeetingEventId(bizMeetingEvent.getId());

                String cUnitNameList = s.getBizMeetingEventDetailsUnitList().stream().map(p -> p.getUnitName()).collect(Collectors.toList()).toString();
                String recUnitName = cUnitNameList.replace("[", "").replace("]", "");
                s.setCooperativeUnitName(recUnitName);

                String mUnitNameList = s.getMainUnitList().stream().map(p -> p.getUnitName()).collect(Collectors.toList()).toString();
                String remUnitName = mUnitNameList.replace("[", "").replace("]", "");
                s.setMainUnitName(remUnitName);

                //修改反馈时限时选择0长期，将所填反馈时限滞空，选择1限时,将所填更新频率滞空
                if(s.getTimePeriod() !=null && s.getTimePeriod()==0){
                    s.setUpdateRate(null);
                }else if (s.getTimePeriod() !=null && s.getTimePeriod()==1){
                    s.setFeedbackTimeLimit(null);
                }
                bizMeetingEventDetailsManager.saveOrUpdate(s);

                //删除不在主要责任单位中数据
//                List<String> mUnitId = s.getMainUnitList().stream().filter(p -> p.getUnitType().equals("1")).map(p -> p.getUnitId()).collect(Collectors.toList());
//                bizMeetingEventDetailsUnitManager.remove(new QueryWrapper<BizMeetingEventDetailsUnit>()
//                        .eq("UNIT_TYPE_","1").notIn("UNIT_ID_",mUnitId));

                bizMeetingEventDetailsUnitManager.remove(new QueryWrapper<BizMeetingEventDetailsUnit>()
                       .eq("EVENT_DETAILS_ID_",s.getId()));

                //增加主要责任单位
                List<BizMeetingEventDetailsUnit> mainUnitList = s.getMainUnitList();
                mainUnitList.stream().forEach(p->{
                    p.setEventId(bizMeetingEvent.getId());
                    p.setEventDetailsId(s.getId());
                    p.setUnitType("1");
                });
                //如果将责任单位删除后，删除之前责任单位在推进信息中所填写过得数据
                List<String> mainUnitIds = mainUnitList.stream().map(BizMeetingEventDetailsUnit::getUnitId).collect(Collectors.toList());
                bizMeetingEventPushManager.remove(new QueryWrapper<BizMeetingEventPush>().eq("DETAILS_ID_",s.getId()).notIn(BeanUtils.isNotEmpty(mainUnitIds),"UNIT_ID_",mainUnitIds).eq("IS_DELE_","0"));

                bizMeetingEventDetailsUnitManager.saveOrUpdateBatch(mainUnitList);


                //删除不在配合单位中数据
//                List<String> cUnitId = s.getBizMeetingEventDetailsUnitList().stream().filter(p -> p.getUnitType().equals("2")).map(p -> p.getUnitId()).collect(Collectors.toList());
//                bizMeetingEventDetailsUnitManager.remove(new QueryWrapper<BizMeetingEventDetailsUnit>()
//                        .eq("UNIT_TYPE_","2").notIn("UNIT_ID_",cUnitId));
                //增加配合单位
                List<BizMeetingEventDetailsUnit> detailsUnitList = s.getBizMeetingEventDetailsUnitList();
                detailsUnitList.stream().forEach(p->{
                    p.setEventId(bizMeetingEvent.getId());
                    p.setEventDetailsId(s.getId());
                    p.setUnitType("2");
                });
                bizMeetingEventDetailsUnitManager.saveOrUpdateBatch(detailsUnitList);

            });


        }
    }

    @Override
    @Transactional
    public boolean modifySendStatus(String ids, String status) {
        UpdateWrapper<BizMeetingEvent> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("SEND_STATUS_",status);
        if (status.equals("1"))updateWrapper.set("SEND_TIME_", LocalDateTime.now());
        updateWrapper.in("ID_", Arrays.asList(ids.split(",")));
        return super.update(updateWrapper);
    }

    @Override
    public BizMeetingEvent detailedById(String id,String unitId) {
        BizMeetingEvent result = super.getById(id);
        result.setFiles(fileManager.queryFileByBizId(id));

        QueryWrapper<BizMeetingEventDetails> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("MEETING_EVENT_ID_",id);
        List<BizMeetingEventDetails> list = bizMeetingEventDetailsManager.list(queryWrapper);

        result.setBizMeetingEventDetailsList(list);
        list.stream().forEach(p->{
            QueryWrapper<BizMeetingEventDetailsUnit> mainUnitQuery = new QueryWrapper<BizMeetingEventDetailsUnit>()
                    .eq("UNIT_TYPE_","1")
                    .eq("EVENT_DETAILS_ID_", p.getId())
                    .eq(BeanUtils.isNotEmpty(unitId),"UNIT_ID_",unitId);
            List<BizMeetingEventDetailsUnit> mainUnitList = bizMeetingEventDetailsUnitManager.list(mainUnitQuery);
            p.setMainUnitList(mainUnitList);

            QueryWrapper<BizMeetingEventDetailsUnit> unitQuery = new QueryWrapper<BizMeetingEventDetailsUnit>()
                    .eq("UNIT_TYPE_","2")
                    .eq("EVENT_DETAILS_ID_", p.getId())
                    .eq(BeanUtils.isNotEmpty(unitId),"UNIT_ID_",unitId);
            List<BizMeetingEventDetailsUnit> unitList = bizMeetingEventDetailsUnitManager.list(unitQuery);
            p.setBizMeetingEventDetailsUnitList(unitList);
        });
        return result;
    }

    @Override
    public boolean isExists(String id,String meetingName) {
        BizMeetingEvent  entity = super.getOne(new QueryWrapper<BizMeetingEvent>()
                .eq(BeanUtils.isNotEmpty(meetingName),"MEETING_NAME_",meetingName)
                .eq("IS_DELE_", "0"),false);
        if (BeanUtils.isEmpty(entity)){
            return true;
        }else if (BeanUtils.isNotEmpty(id)&&BeanUtils.isNotEmpty(entity)){
            return entity.getId().equals(id);
        }
       return false;
    }
}
