package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizMeetingEvent;
import com.artfess.reform.fill.model.BizMeetingEventDetails;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Description:会议议定事项详情表 服务类
 * @Author: Rong Tao
 * @Date: 2023/4/3 17:15
 */
public interface BizMeetingEventDetailsManager extends BaseManager<BizMeetingEventDetails> {

    /**
     * 批量添加或修改数据
     * @param bizMeetingEventDetailsList
     */
    void saveOrUpdateList(List<BizMeetingEventDetails> bizMeetingEventDetailsList);

    /**
     * 添加或修改数据
     * @param bizMeetingEventDetails
     */
    void saveOrUpdateEntity(BizMeetingEventDetails bizMeetingEventDetails);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BizMeetingEventDetails> queryByPage(QueryFilter<BizMeetingEventDetails> queryFilter,boolean isAffirm);


    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    BizMeetingEventDetails detailedById(String id);

    /**
     * 根据id修改状态
     * @param ids
     * @param status
     * @return
     */
    boolean modifyStatus(String ids,String status);

    /**
     * 批量导出功能
     * @param response
     * @param queryFilter
     * @throws Exception
     */
    void exportExcel(HttpServletResponse response, QueryFilter<BizMeetingEventDetails> queryFilter,boolean isAffirm) throws Exception;

    /**
     * 删除数据
     * @param id
     * @return
     */
    boolean deleteInfo(String id);
}
