package com.artfess.reform.fill.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizMeetingDocumentsConsidered;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.fill.model.BizMeetingDocumentsPush;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 会议审议通过文件管理表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
public interface BizMeetingDocumentsConsideredManager extends BaseManager<BizMeetingDocumentsConsidered> {
   /**
    * 需对接文件状态更新分页查询
    * @param queryFilter
    * @return
    */
   PageList<BizMeetingDocumentsConsidered> queryPush(QueryFilter<BizMeetingDocumentsConsidered> queryFilter);

   /**
    * 需对接文件审核查询
    * @param queryFilter
    * @param isAffirm
    * @return
    */
   PageList<BizMeetingDocumentsConsidered> queryAudit(QueryFilter<BizMeetingDocumentsConsidered> queryFilter,boolean isAffirm);

   /**
    * 根据id删除数据,如有多个用逗号隔开
    * @param ids
    * @return
    */
   Boolean removeById(String ids);

   /**
    * 添加实体类
    * @param bizMeetingDocumentsConsidered
    * @return
    */
   Boolean insertInfo(BizMeetingDocumentsConsidered bizMeetingDocumentsConsidered);

   /**
    * 保存实体类
    * @param bizMeetingDocumentsConsidered
    */
   void updateInfo(BizMeetingDocumentsConsidered bizMeetingDocumentsConsidered);

   /**
    * 修改分发状态
    * @param bizMeetingDocumentsConsidered
    */
   void updateByStatus(BizMeetingDocumentsConsidered bizMeetingDocumentsConsidered);

   /**
    * 查询详情当前记录和历史记录
    * @param id
    * @param unitId
    * @return
    */
   List<BizMeetingDocumentsPush> findByHis(String id,String unitId);

   /**
    * 查询录入详情
    * @param id
    * @return
    */
   BizMeetingDocumentsConsidered findByModel(String id);

   /**
    * 批量导出功能
    * @param response
    * @param queryFilter
    * @throws Exception
    */
   void exportExcel(HttpServletResponse response, QueryFilter<BizMeetingDocumentsConsidered> queryFilter) throws Exception;
}
