package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.manager.BizMeetingCooperativeUnitManager;
import com.artfess.reform.fill.model.BizMeetingCooperativeUnit;
import com.artfess.reform.fill.model.BizMeetingDocumentsConsidered;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizMeetingMattersAgreed;
import com.artfess.reform.fill.manager.BizMeetingMattersAgreedManager;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 会议议定事项表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@RestController
@RequestMapping("/bizMeetingMattersAgreed/v1/")
@Api(tags = "会议议定事项")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMeetingMattersAgreedController extends BaseController<BizMeetingMattersAgreedManager, BizMeetingMattersAgreed> {


    @Autowired
    private BaseContext baseContext;

    @Resource
    private BizMeetingCooperativeUnitManager bizMeetingCooperativeUnitManager;

    @Resource
    private FileManager fileManager;



    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    @Transactional
    public CommonResult<String> create(@RequestBody BizMeetingMattersAgreed bizMeetingMattersAgreed) {
        BizMeetingCooperativeUnit unit = new BizMeetingCooperativeUnit();
        unit.setUnitId(bizMeetingMattersAgreed.getUnitId());
        unit.setUnitName(bizMeetingMattersAgreed.getUnitName());
        unit.setUnitCode(bizMeetingMattersAgreed.getUnitCode());
        unit.setUnitGrade(bizMeetingMattersAgreed.getUnitGrade());
        unit.setMaiinType(1);
        unit.setTenantId("-1");
        CommonResult<String> result = super.create(bizMeetingMattersAgreed);
        unit.setMeetingId(bizMeetingMattersAgreed.getId());
        bizMeetingCooperativeUnitManager.create(unit);
        if (BeanUtils.isNotEmpty(bizMeetingMattersAgreed.getIds())){
            bizMeetingMattersAgreed.getIds().stream().forEach(p->{
                fileManager.update(new UpdateWrapper<DefaultFile>().eq("id_",p).eq("IS_DELE_","0").set("biz_id_",bizMeetingMattersAgreed.getId()));
            });
        }
        return result;
    }


    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        Map<String, Object> map = new HashMap<>();
        map.put("MEETING_ID_", id);
        bizMeetingCooperativeUnitManager.removeByMap(map);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/updateInfo")
    @ApiOperation("更新实体")
    public CommonResult<String> updateInfo(@RequestBody BizMeetingMattersAgreed bizMeetingMattersAgreed) {
        if (bizMeetingMattersAgreed.getStatus().equals(0)||bizMeetingMattersAgreed.getStatus().equals(2)){
            if (BeanUtils.isNotEmpty(bizMeetingMattersAgreed.getIds())){
                bizMeetingMattersAgreed.getIds().stream().forEach(p->{
                    fileManager.update(new UpdateWrapper<DefaultFile>().eq("id_",p).eq("IS_DELE_","0").set("biz_id_",bizMeetingMattersAgreed.getId()));
                });
            }
            return super.updateById(bizMeetingMattersAgreed);
        }
        return new CommonResult<>(false,"审批中的记录无法修改");
    }

    @PostMapping("/updateStatus")
    @ApiOperation("修改状态")
    public CommonResult<String> updateStatus(@RequestBody BizMeetingMattersAgreed bizMeetingMattersAgreed) {
        return super.updateById(bizMeetingMattersAgreed);
    }

    @Override
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("录入分页查询")
    public PageList<BizMeetingMattersAgreed> query(@RequestBody QueryFilter<BizMeetingMattersAgreed> queryFilter) {
//        queryFilter.addFilter("STATUS_",3, QueryOP.LESS);
        super.query(queryFilter).getRows().stream().forEach(p->{
          p.setFiles(fileManager.list(new QueryWrapper<DefaultFile>().eq("BIZ_ID_",p.getId()).eq("IS_DELE_","0")));
        });
        return super.query(queryFilter);
    }

    @PostMapping("/getUnitList")
    @ApiOperation("更新分页查询")
    public CommonResult<PageList<BizMeetingMattersAgreed>> getLeaderList(@RequestBody QueryFilter<BizMeetingMattersAgreed> queryFilter) {
        queryFilter.addFilter("UNIT_ID_",baseContext.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_","0",QueryOP.EQUAL);
//        queryFilter.addFilter("STATUS_",3, QueryOP.LESS);
        super.query(queryFilter).getRows().stream().forEach(p->{
            p.setFiles(fileManager.list(new QueryWrapper<DefaultFile>().eq("BIZ_ID_",p.getId()).eq("IS_DELE_","0")));
        });
        return new CommonResult<PageList<BizMeetingMattersAgreed>>(true, "查询成功", super.query(queryFilter));
    }

    @PostMapping("/getUnitLeaderList")
    @ApiOperation("审核分页查询")
    public CommonResult<PageList<BizMeetingMattersAgreed>> getUnitLeaderList(@RequestBody QueryFilter<BizMeetingMattersAgreed> queryFilter) {
        queryFilter.addFilter("UNIT_ID_",baseContext.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_","0",QueryOP.EQUAL);
//        List<Integer> status = new ArrayList<>();
//        status.add(1);
//        status.add(3);
//        status.add(4);
//        queryFilter.addFilter("STATUS_",status,QueryOP.IN);
        super.query(queryFilter).getRows().stream().forEach(p->{
            p.setFiles(fileManager.list(new QueryWrapper<DefaultFile>().eq("BIZ_ID_",p.getId()).eq("IS_DELE_","0")));
        });
        return new CommonResult<PageList<BizMeetingMattersAgreed>>(true, "查询成功", super.query(queryFilter));
    }

    @PostMapping("/getAffirmList")
    @ApiOperation("确认分页查询")
    public CommonResult<PageList<BizMeetingMattersAgreed>> getAffirmList(@RequestBody QueryFilter<BizMeetingMattersAgreed> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0",QueryOP.EQUAL);
//        List<Integer> status = new ArrayList<>();
//        status.add(3);
//        status.add(5);
//        queryFilter.addFilter("STATUS_",status,QueryOP.IN);
        super.query(queryFilter).getRows().stream().forEach(p->{
            p.setFiles(fileManager.list(new QueryWrapper<DefaultFile>().eq("BIZ_ID_",p.getId()).eq("IS_DELE_","0")));
        });
        return new CommonResult<PageList<BizMeetingMattersAgreed>>(true, "查询成功", super.query(queryFilter));
    }
}
