package com.artfess.reform.statistics.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.statistics.model.BizScoringCountyWorkable;
import com.artfess.reform.statistics.manager.BizScoringCountyWorkableManager;

import java.time.LocalDate;
import java.util.List;

/**
 * 区县落实改革力评分结果 前端控制器
 *
 * @author chens
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-27
 */
@Slf4j
@RestController
@Api(tags = "区县落实改革力评分结果接口")
@RequestMapping("/statistics/bizScoringCountyWorkable/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizScoringCountyWorkableController extends BaseController<BizScoringCountyWorkableManager, BizScoringCountyWorkable> {


    @GetMapping("/testCountScore")
    public List<BizScoringCountyWorkable> testCountScore(@RequestParam("countDate")LocalDate countDate) {
        return baseService.countScore(countDate);
    }

}
