package com.artfess.reform.majorProjects.vo;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.artfess.file.model.DefaultFile;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 项目具体举措计划推进情况
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */


@Data
@ApiModel(value="PilotMeasuresVo对象", description="进度计划集合-包含计划推进情况草稿")
public class PilotMeasuresVo extends PilotSpecificSchedule {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "数据ID")
    private String dataId;

    @ApiModelProperty(value = "填报ID")
    private String fillId;

    @ApiModelProperty(value = "举措明细计划ID（关联举措明细计划表ID）")
    private String planId;

    @ApiModelProperty(value = "是否完成（0：未完成，1：已完成）")
    private String isOver;

    @ApiModelProperty(value = "已完成工作")
    private String completedWork;

    @ApiModelProperty(value = "存在问题")
    private String problems;

    @ApiModelProperty(value = "下步工作计划")
    private String workPlan;

    @ApiModelProperty(value = "附件集合")
    private List<DefaultFile> defaultFileList;
}
