package com.artfess.reform.majorProjects.model;

import java.math.BigDecimal;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;

import java.time.LocalDate;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 改革方案量化目标进度计划推进情况
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@TableName("BIZ_PILOT_QUANTITATIVE_OBJECTIVES_PUSH")
@ApiModel(value="BizPilotQuantitativeObjectivesPush对象", description="改革方案量化目标进度计划推进情况")
public class PilotQuantitativeObjectivesPush extends AutoFillFullModel<PilotQuantitativeObjectivesPush> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;


    @ApiModelProperty(value = "填报ID（关联市级重大改革项目填报审核记录表ID）")
    @TableField("FILL_ID_")
    private String fillId;

    @ApiModelProperty(value = "量化目标表ID（关联量化目标表ID）")
    @TableField("OBJECTIVES_MEASURES_ID_")
    private String objectivesMeasuresId;


    @ApiModelProperty(value = "目标推进值")
    @TableField("PUSH_PROGRESS_")
    private BigDecimal pushProgress;

    @ApiModelProperty(value = "目标推进时间")
    @TableField("PUSH_DATE_")
    private LocalDate pushDate;


    @ApiModelProperty(value = "达标率")
    @TableField("COMPLIANCE_RATE_")
    private BigDecimal complianceRate;

    @ApiModelProperty(value = "当月完成率")
    @TableField("MONTH_RATE_")
    private BigDecimal monthRate;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDelete",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    protected String isDele = "0";

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<DefaultFile> defaultFileList;
}
