package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 项目具体举措计划（月度计划）推进情况
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-10-17
 */

@Data
@TableName("BIZ_PILOT_NOT_START_MEASURES_PUSH")
@ApiModel(value="BizPilotNotStartMeasuresPush对象", description="项目具体举措计划（月度计划）推进情况")
public class BizPilotNotStartMeasuresPush extends AutoFillFullModel<BizPilotNotStartMeasuresPush> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "填报ID")
    @TableField("FILL_ID_")
    private String fillId;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "计划年份")
    @TableField("PLAN_YEAR_")
    private Integer planYear;

    @ApiModelProperty(value = "计划季度")
    @TableField("PLAN_QUARTER_")
    private Integer planQuarter;

    @ApiModelProperty(value = "计划月份")
    @TableField("PLAN_MONTH_")
    private Integer planMonth;

    @ApiModelProperty(value = "已完成工作")
    @TableField("COMPLETED_WORK_")
    private String completedWork;

    @ApiModelProperty(value = "存在问题")
    @TableField("PROBLEMS_")
    private String problems;

    @ApiModelProperty(value = "下步工作计划")
    @TableField("WORK_PLAN_")
    private String workPlan;

    @ApiModelProperty(value = "审核状态（使用字典，0：草稿，1：提交改革办核准，2：改革办审核驳回，,3：改革办审核通过）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "涉密（文件涉密，已从内网邮箱上传）")
    @TableField("CLASSIFIED_")
    private String classified;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele="0";

    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    private List<DefaultFile> files;

}
