package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformRiskManagement;
import com.artfess.reform.fill.vo.StateVO;
import com.artfess.reform.majorProjects.dao.PilotProjectFillDao;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotProjectFillManager;
import com.artfess.reform.majorProjects.model.*;
import com.artfess.reform.majorProjects.dao.PilotBrandPushDao;
import com.artfess.reform.majorProjects.manager.PilotBrandPushManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.majorProjects.vo.PilotProjectFillCreateVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目品牌显示度情况 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
@Service
public class BizPilotBrandPushManagerImpl extends BaseManagerImpl<PilotBrandPushDao, PilotBrandPush> implements PilotBrandPushManager {

    @Resource
    private FileManager fileManager;
    @Resource
    private SysDictionaryManager  sysDictionaryManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    private PilotProjectFillManager pilotProjectFillManager;
    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;
    @Resource
    private UniversalWayManager universalWayManager;


    @Override
    public List<PilotBrandPush> queryListByFillId(String id) {
        QueryWrapper<PilotBrandPush> queryWrapper = new QueryWrapper();
        queryWrapper.eq("FILL_ID_", id).eq("IS_DELE_", 0);
        List<PilotBrandPush> list = this.list(queryWrapper);
        if(null != list && list.size() > 0){
            list.stream().forEach(p->{
                p.setFiles(fileManager.queryFileByBizId(p.getId()));
            });
        }
        return list;
    }

    @Override
    @Transactional
    public void insertInfo(PilotProjectFillCreateVo pilotProjectFillCreateVo) {
        Assert.notNull(pilotProjectFillCreateVo, "保存数据不能为空");
        // 1.保存填报信息
        PilotProjectFill pilotProjectFill = pilotProjectFillCreateVo.getPilotProjectFill();
        Assert.notNull(pilotProjectFill, "填报审核记录数据不能为空");
        Assert.notNull(pilotProjectFill.getProjectId(), "填报审核记录未关联项目【projectId】");
        LocalDate fillDate = LocalDate.now();
        int quarter = (fillDate.getMonthValue() - 1) / 3 + 1;
        pilotProjectFill.setFillDate(fillDate);
        pilotProjectFill.setFillYear(fillDate.getYear());
        pilotProjectFill.setFillMonth(fillDate.getMonthValue());
        pilotProjectFill.setFillQuarter(quarter);
        pilotProjectFill.setFlowType(4);
        pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
        pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
        pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
        pilotProjectFill.setUnitGrade(ContextUtil.getCurrentOrgGrade());
        pilotProjectFillManager.save(pilotProjectFill);

        //操作日志录入
        setApprovalLog(pilotProjectFill.getId(),pilotProjectFill.getApprovalResults(),pilotProjectFill.getStatus(),pilotProjectFill.getApprovalComments());


        //项目品牌显示度情况集合
        pilotProjectFillCreateVo.getPilotBrandPushList().stream().forEach(p -> {
            p.setFillId(pilotProjectFill.getId());
            p.setProjectId(pilotProjectFill.getProjectId());
            p.setIsDelete("0");
            super.save(p);
            if (BeanUtils.isNotEmpty(p.getIds())) universalWayManager.attachmentUpdates(p.getIds(), p.getId());
        });

    }

    @Override
    @Transactional
    public void  updateInfo(PilotProjectFillCreateVo pilotProjectFillCreateVo) {
        // 1.保存填报信息
        LocalDate fillDate = LocalDate.now();
        int quarter = (fillDate.getMonthValue() - 1) / 3 + 1;
        PilotProjectFill pilotProjectFill = pilotProjectFillCreateVo.getPilotProjectFill();

        //修改时,录入操作日志判断
        PilotProjectFill entity = pilotProjectFillManager.getById(pilotProjectFillCreateVo.getPilotProjectFill().getId());
        if(pilotProjectFill.getStatus()==1&&entity.getStatus()==0){
            setApprovalLog(pilotProjectFill.getId(),pilotProjectFill.getApprovalResults(),pilotProjectFill.getStatus(),pilotProjectFill.getApprovalComments());
        }

        pilotProjectFillManager.update(new UpdateWrapper<PilotProjectFill>()
                .eq("ID_",pilotProjectFill.getId())
                .eq("FLOW_TYPE_",4)
                .set("STATUS_",pilotProjectFill.getStatus())
                .set("FILL_DATE_",fillDate)
                .set("FILL_YEAR_",fillDate.getYear())
                .set("FILL_QUARTER_",quarter)
                .set("FILL_MONTH_",fillDate.getMonthValue()));

         //删除之前品牌显示度数据
        List<String> ids = pilotProjectFillCreateVo.getPilotBrandPushList().stream().map(PilotBrandPush::getId).collect(Collectors.toList());
        super.remove(new QueryWrapper<PilotBrandPush>().eq("FILL_ID_",pilotProjectFill.getId()).notIn("ID_",ids).eq("IS_DELE_","0"));
        //项目品牌显示度情况集合
        pilotProjectFillCreateVo.getPilotBrandPushList().stream().forEach(p -> {
            p.setFillId(pilotProjectFill.getId());
            p.setProjectId(pilotProjectFill.getProjectId());
            super.saveOrUpdate(p);
           if(BeanUtils.isNotEmpty(p.getIds())) universalWayManager.attachmentUpdates(p.getIds(), p.getId());
        });
    }



    @Override
    public List<PilotProjectFill> findByHis(String projectId) {
        List<PilotProjectFill> list = pilotProjectFillManager.list(new QueryWrapper<PilotProjectFill>().eq("PROJECT_ID_", projectId).eq("FLOW_TYPE_",4).orderByDesc("CREATE_TIME_").last("limit 2"));
        list.stream().forEach(p->{
           List<PilotBrandPush> models = super.list(new QueryWrapper<PilotBrandPush>()
                   .eq("FILL_ID_",p.getId())
                   .eq("IS_DELE_", "0"));
            //查询附件信息
            models.stream().forEach(t->{
                List<DefaultFile> files = fileManager.list(new QueryWrapper<DefaultFile>().eq("BIZ_ID_", t.getId()).eq("IS_DEL_", "0"));
                if (BeanUtils.isNotEmpty(files)){
                    t.setFiles(files);
                }
            });
           p.setPilotBrandPushList(models);
            //从操作日志记录表中获取提交驳回意见
            if (BeanUtils.isNotEmpty(p)) {
                AchieveStatusLog log = achieveStatusLogManager.getOne(new QueryWrapper<AchieveStatusLog>()
                        .eq("BIZ_ID_", p.getId())
                        .orderByDesc("OPERATE_DATE_")
                        .last("LIMIT 1"));
                if (BeanUtils.isNotEmpty(log)&&p.getStatus()!=0&&p.getStatus()!=1&&p.getStatus()!=3&&p.getStatus()!=5) {
                    p.setApprovalComments(log.getApprovalComments());
                }
            }
       });
        return list;
    }

    @Override
    public PilotProjectFill findById(String projectId, Integer year, Integer month) {
        LocalDate fillDate = LocalDate.now();
        PilotProjectFill fill = pilotProjectFillManager.getOne(new QueryWrapper<PilotProjectFill>()
                .eq("PROJECT_ID_", projectId)
                .eq("FLOW_TYPE_",4)
                .eq("STATUS_",5)
                .and(e->e.le("FILL_MONTH_",month==null?fillDate.getMonthValue():month).eq("FILL_YEAR_",year==null?fillDate.getYear():year))
                .orderByDesc("CREATE_TIME_").last("limit 1"));
         if (fill!=null){
             List<PilotBrandPush> models = super.list(new QueryWrapper<PilotBrandPush>()
                     .eq("FILL_ID_",fill.getId())
                     .eq("IS_DELE_", "0"));
             //查询附件信息
             models.stream().forEach(t->{
                 List<DefaultFile> files = fileManager.list(new QueryWrapper<DefaultFile>().eq("BIZ_ID_", t.getId()).eq("IS_DEL_", "0"));
                 if (BeanUtils.isNotEmpty(files)){
                     t.setFiles(files);
                 }
             });
             fill.setPilotBrandPushList(models);
         }
          return fill;
    }

    @Override
    @Transactional
    public boolean updateByStatus(PilotProjectFill pilotProjectFill) {
        boolean res = pilotProjectFillManager.update(new UpdateWrapper<PilotProjectFill>().eq("ID_",pilotProjectFill.getId()).eq("FLOW_TYPE_",4).set("STATUS_",pilotProjectFill.getStatus()));
        setApprovalLog(pilotProjectFill.getId(),pilotProjectFill.getApprovalResults(),pilotProjectFill.getStatus(),pilotProjectFill.getApprovalComments());
        return res;
    }

    private void setApprovalLog(String id,Integer approvalResults,Integer status,String approvalComments){
        // 审批日志
        PilotProjectFill model = pilotProjectFillManager.getOne(new QueryWrapper<PilotProjectFill>().eq("ID_",id).eq("IS_DELE_","0"));
        MunicipalMajorProjectManagement manager = municipalMajorProjectManagementManager.getOne(new QueryWrapper<MunicipalMajorProjectManagement>().eq("ID_",model.getProjectId()).eq("IS_DELE_","0"));
        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("6-4");
        logVo.setModuleTableName("BIZ_PILOT_PROJECT_FILL");
        if (BeanUtils.isNotEmpty(approvalResults)&&approvalResults==2){
            if (status==0){
                logVo.setItemTitle("【"+manager.getProjectName()+"】撤回为草稿状态");
                logVo.setOperateInfo("撤回为草稿");
            }else if (status==1){
                logVo.setItemTitle("【"+manager.getProjectName()+"】撤回为提交待审核");
                logVo.setOperateInfo("撤回为提交待审核");
            }else if (status==3){
                logVo.setItemTitle("【"+manager.getProjectName()+"】撤回为责任单位领导审核通过");
                logVo.setOperateInfo("撤回为责任单位领导审核通过");
            }
            logVo.setApprovalResults(2);
        }else {

            if (status%2==0){
                logVo.setApprovalResults(1);
            }else {
                logVo.setApprovalResults(0);
            }

            if (status==0){
                logVo.setItemTitle("【"+manager.getProjectName()+"】品牌显示度录入");
            } else {
                logVo.setItemTitle("【"+manager.getProjectName()+"】"+BizUtils.getDicValueByCode(shzt, status));
            }
            logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, status));
        }

        logVo.setStatus(status.toString());
        if (status==2||status==4){
            logVo.setApprovalComments(approvalComments);
        }
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }
}
