package com.artfess.reform.majorProjects.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasures;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasuresHistory;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.majorProjects.vo.IterationEntityVO;

import java.util.List;

/**
 * 改革方案明确的具体举措迭代历史表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
public interface PilotSpecificMeasuresHistoryManager extends BaseManager<PilotSpecificMeasuresHistory> {

    /**
     * 迭代措施主页面分页查询
     * @param queryFilter
     * @return
     */
    PageList<PilotSpecificMeasuresHistory> pageList(QueryFilter<PilotSpecificMeasuresHistory> queryFilter,boolean isAffirm,boolean isInput);


    /**
     * 更新原举措分页查询
     * @return
     */
    PageList<PilotSpecificMeasuresHistory> iterateInfo(QueryFilter<PilotSpecificMeasuresHistory> queryFilter);

    /**
     *审核页面详情分页查询
     * @param queryFilter
     * @return
     */
    PageList<PilotSpecificMeasuresHistory> auditInfo(QueryFilter<PilotSpecificMeasuresHistory> queryFilter);

    /**
     * 新增迭代分页查询
     * @param queryFilter
     * @return
     */
    PageList<PilotSpecificMeasuresHistory> addInfo(QueryFilter<PilotSpecificMeasuresHistory> queryFilter);

    /**
     * 删除迭代数据
     */
    boolean deleteById(String id,boolean isAffirm);
}
