package com.artfess.reform.majorProjects.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.MunicipalMajorProjectAllVo;
import com.artfess.reform.majorProjects.vo.MunicipalMajorProjectManagementVo;
import com.artfess.reform.majorProjects.vo.PushCommitVo;
import com.artfess.reform.majorProjects.vo.PushExamineVo;

import java.io.Serializable;
import java.util.List;

/**
 * 市级重大改革项目管理表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
public interface MunicipalMajorProjectManagementManager extends BaseManager<MunicipalMajorProjectManagement> {

    /**
     * 不分页查询所有项目
     * @param queryFilter
     * @return
     */
    List<MunicipalMajorProjectManagement> queryAll(QueryFilter<MunicipalMajorProjectManagement> queryFilter);

    /**
     * 分页查询有跌打
     * @param queryFilter
     * @return
     */
    PageList<MunicipalMajorProjectManagement> queryIterationProject(QueryFilter<MunicipalMajorProjectManagement> queryFilter);

    /**
     * 目标推进情况、进度计划推进情况审核保存接口
     * @param pushCommitVo
     */
    void pushSave(PushCommitVo pushCommitVo);

    /**
     * 目标推进情况、进度计划推进情况审核保存接口
     * @param pushCommitVo
     */
    void pushSaveAndCommit(PushCommitVo pushCommitVo);

    /**
     * 目标推进情况、进度计划推进情况审核接口
     * @param pushExamineVo
     */
    void pushExamine(PushExamineVo pushExamineVo);

    /**
     * 带权限分页查询数据
     * @param queryFilter
     * @return
     */
    PageList<MunicipalMajorProjectManagement> queryList(QueryFilter<MunicipalMajorProjectManagement> queryFilter);

//    /**
//     * 审批填报初始化信息
//     * @param pilotProjectFill
//     * @return
//     */
//    MunicipalMajorProjectManagement getExamineById(PilotProjectFill pilotProjectFill);

    /**
     * 量化目标推进初始化
     * @param pilotProjectFill
     * @return
     */
    MunicipalMajorProjectManagement getPilotQuantitativeObjectivesVoById(PilotProjectFill pilotProjectFill);

    /**
     * 量化目标推进初始化
     * @param pilotProjectFill
     * @return
     */
    MunicipalMajorProjectManagement getPilotMeasuresVoAndPilotSpecificSchedulePushById(PilotProjectFill pilotProjectFill);

    /**
     * 查询所有项目
     * @param queryFilter
     * @return
     */
    PageList<MunicipalMajorProjectManagement> queryProjectList(QueryFilter<MunicipalMajorProjectManagement> queryFilter);

    /**
     * 根据ID单独查询项目信息，不再查询任何子表新
     * @param id 项目ID
     * @return
     */
    MunicipalMajorProjectManagement getMunicipalMajorProjectManagement(Serializable id);

    /**
     * 判断是否存在相同的数据
     * @param municipalMajorProjectManagement
     * @return
     */
    boolean isExists(MunicipalMajorProjectManagement municipalMajorProjectManagement);

    /**
     * 保存项目信息并修改审核状态
     * @param municipalMajorProjectManagement
     * @return
     */
    boolean updateStatus(MunicipalMajorProjectManagement municipalMajorProjectManagement);

    /**
     * 撤销重大项目的前一步审核状态
     * @param id 项目ID
     * @param status 项目状态
     * @param approvalResults 执行结果（0：同意，1：驳回，2：撤回）
     * @return
     */
    boolean revocation(String id,Integer status,Integer approvalResults);

    /**
     * 修改下发状态
     * @param id 项目ID
     * @return
     */
    boolean updateSendStatus(String id);

    /**
     * 带权限查询基本信息和最近一次上报日期
     * @param queryFilter
     * @return
     */
    PageList<MunicipalMajorProjectManagement> queryByPage(QueryFilter<MunicipalMajorProjectManagement> queryFilter);

    /**
     * 带权限查询基本信息和最近一次上报日期
     * @param queryFilter
     * @return
     */
    PageList<MunicipalMajorProjectManagement> queryByPageGroup(QueryFilter<MunicipalMajorProjectManagement> queryFilter,String code);

    /**
     * 重大项目大屏整体查询
     * @param id
     * @param year
     * @param month
     * @return
     */
    MunicipalMajorProjectAllVo overAllQuery(String id, Integer year, Integer month);
}
