package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.query.*;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizWorkNews;
import com.artfess.reform.fill.dao.BizWorkNewsDao;
import com.artfess.reform.fill.manager.BizWorkNewsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import net.hasor.db.transaction.interceptor.Transactional;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;


/**
 * 工作动态 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-04-07
 */
@Service
public class BizWorkNewsManagerImpl extends BaseManagerImpl<BizWorkNewsDao, BizWorkNews> implements BizWorkNewsManager {
@Resource
private UniversalWayManager universalWayManager;
@Resource
private AchieveStatusLogManager achieveStatusLogManager;
    @Override
    @Transactional
    public void deleteInfo(String ids) {
        Assert.notNull(ids,"需要删除的id不能为空");
        String[] res = ids.split(",");
        for (String id : res) {
            if (super.getById(id).getStatus()!=0){
                throw new BaseException("无法删除审核中数据！");
            }
            super.removeById(id);
            //删除附件
            universalWayManager.deleteFiles(id);
        }
    }

    @Override
    @Transactional
    public boolean saveOrUpdateEntity(BizWorkNews bizWorkNews) {
        //判断是否满足操作日志记录
        boolean check = check(bizWorkNews);
        boolean res = super.saveOrUpdate(bizWorkNews);
        //记录操作日志
        if (check) setApprovalLog(bizWorkNews);
        //记录附件
        universalWayManager.attachmentUpdates(bizWorkNews.getIds(),bizWorkNews.getId());
        return res;
    }


    @Override
    @Transactional
    public boolean updateInfo(BizWorkNews bizWorkNews) {
        Assert.notNull(bizWorkNews.getId(),"需要修改的id不能为空");
        //判断是否满足操作日志记录
        boolean check = check(bizWorkNews);
        UpdateWrapper<BizWorkNews> updateWrapper=new UpdateWrapper<>();
        updateWrapper.eq("ID_",bizWorkNews.getId())
                     .eq("IS_DELE_","0")
                     .set("STATUS_",bizWorkNews.getStatus());
        super.update(bizWorkNews);
        if (check) setApprovalLog(bizWorkNews);
        return bizWorkNews.getId()!=null;
    }

    @Override
    public PageList<BizWorkNews> queryInfo(QueryFilter<BizWorkNews> queryFilter,boolean isAffirm) {
        if (!ContextUtil.getCurrentUser().isAdmin()&&!isAffirm){
            queryFilter.addFilter("CREATE_ORG_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("IS_DELE_","0",QueryOP.EQUAL);
        IPage<BizWorkNews> iPage = baseMapper.queryInfo(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public  PageList<BizWorkNews>  screenInfo(QueryFilter<BizWorkNews> queryFilter) {
        queryFilter.addFilter("n.IS_DELE_","0",QueryOP.EQUAL);
        queryFilter.addFilter("n.STATUS_",5,QueryOP.EQUAL);
        IPage<BizWorkNews> iPage = baseMapper.screenInfo(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }


    @Transactional
    public void setApprovalLog(BizWorkNews bizWorkNews) {
        // 审批日志
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(bizWorkNews.getId());
        logVo.setModeType(1);
        logVo.setBizType("10");
        logVo.setApprovalComments(bizWorkNews.getApprovalComments());
        logVo.setModuleTableName("BIZ_WORK_NEWS");

        //0：草稿，1：已录入待审核，2：审核驳回，3：审核通过【改革办待审核】 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成
        if (bizWorkNews.getApprovalResults()!=null&&bizWorkNews.getApprovalResults()==2){
            if(bizWorkNews.getStatus()==0){
                logVo.setItemTitle("【"+bizWorkNews.getTitle()+"】撤回为草稿！");
                logVo.setOperateInfo("撤回为草稿");
            }else if(bizWorkNews.getStatus()==1){
                logVo.setItemTitle("【"+bizWorkNews.getTitle()+"】撤回为提交本级审核！");
                logVo.setOperateInfo("撤回为提交本级审核");
            }else if(bizWorkNews.getStatus()==3){
                logVo.setItemTitle("【"+bizWorkNews.getTitle()+"】撤回为提交改革办核准！");
                logVo.setOperateInfo("撤回为提交改革办核准");
            }
            logVo.setApprovalResults(2);
        }else {
            if(bizWorkNews.getStatus()==0){
                logVo.setItemTitle("【"+bizWorkNews.getTitle()+"】草稿！");
                logVo.setOperateInfo("保存为草稿");
                logVo.setApprovalResults(0);
            }else if(bizWorkNews.getStatus()==1){
                logVo.setItemTitle("【"+bizWorkNews.getTitle()+"】提交本级审核！");
                logVo.setOperateInfo("提交本级审核");
                logVo.setApprovalResults(0);
            }else if(bizWorkNews.getStatus()==2){
                logVo.setItemTitle("【"+bizWorkNews.getTitle()+"】本级审核驳回！");
                logVo.setOperateInfo("本级审核驳回");
                logVo.setApprovalResults(1);
            }else if(bizWorkNews.getStatus()==3){
                logVo.setItemTitle("【"+bizWorkNews.getTitle()+"】提交改革办核准！");
                logVo.setOperateInfo("提交改革办核准");
                logVo.setApprovalResults(0);
            }else if(bizWorkNews.getStatus()==4){
                logVo.setItemTitle("【"+bizWorkNews.getTitle()+"】改革办核准驳回！");
                logVo.setOperateInfo("改革办核准驳回");
                logVo.setApprovalResults(1);
            }else if(bizWorkNews.getStatus()==5){
                logVo.setItemTitle("【"+bizWorkNews.getTitle()+"】改革办核准通过！");
                logVo.setOperateInfo("改革办核准通过");
                logVo.setApprovalResults(0);
            }
        }
        logVo.setStatus(bizWorkNews.getStatus().toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    //判断是否满足记录操作日志，避免重复记录
    boolean check(BizWorkNews bizWorkNews){
        BizWorkNews entity = super.getOne(new QueryWrapper<BizWorkNews>()
                .eq("ID_", bizWorkNews.getId())
                .eq("IS_DELE_", "0"), false);
        return entity==null||entity.getStatus()!=bizWorkNews.getStatus();
    }
}
