package com.artfess.reform.fill.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.model.BizReformSatisfactionProject;
import com.artfess.reform.fill.dao.BizReformSatisfactionProjectDao;
import com.artfess.reform.fill.manager.BizReformSatisfactionProjectManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;


/**
 * 项目改革满意度管理 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@Service
public class BizReformSatisfactionProjectManagerImpl extends BaseManagerImpl<BizReformSatisfactionProjectDao, BizReformSatisfactionProject> implements BizReformSatisfactionProjectManager {
@Resource
BaseContext baseContext;
    @Override
    public PageList<BizReformSatisfactionProject> pageList(QueryFilter<BizReformSatisfactionProject> queryFilter) {
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        queryFilter.addFilter("CREATE_ORG_ID_",baseContext.getCurrentOrgId(),QueryOP.EQUAL);
        PageList<BizReformSatisfactionProject> model = this.query(queryFilter);
        return model;
    }
}
