package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;
import com.artfess.reform.fill.dao.BizReformDemandAssignmentRecordDao;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentRecordManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * 需求交办推进记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
@Service
public class BizReformDemandAssignmentRecordManagerImpl extends BaseManagerImpl<BizReformDemandAssignmentRecordDao, BizReformDemandAssignmentRecord> implements BizReformDemandAssignmentRecordManager {

    @Resource
    private BizReformDemandAssignmentManager assignmentManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    private UniversalWayManager universalWayManager;

    @Override
    @Transactional
    public String insertInfo(BizReformDemandAssignmentRecord record) {
        if(record.getStatus() ==null){
            record.setStatus(0);
        }
        record.setReportingUnitId(ContextUtil.getCurrentOrgId());
        record.setReportingUnitName(ContextUtil.getCurrentOrgName());
        record.setResponsibleUnitCode(ContextUtil.getCurrentOrgCode());
        record.setResponsibleUnitGrade(ContextUtil.getCurrentOrgGrade());
        record.setReportingTime(LocalDateTime.now());
        this.baseMapper.insert(record);

        if (BeanUtils.isNotEmpty(record.getIds())){
            universalWayManager.attachmentUpdates(record.getIds(), record.getId());
        }

        setApprovalLog(record.getId(),record.getProjectId(),record.getStatus(),"",record.getApprovalResults());
        return record.getId();
    }

    @Override
    @Transactional
    public String updateInfo(BizReformDemandAssignmentRecord record) {
        BizReformDemandAssignmentRecord old = this.baseMapper.selectById(record.getId());
        //判断是否满足记录操作日志条件,避免重复记录
        boolean check=old==null||old.getStatus()!=record.getStatus();
        if(old.getStatus()==0 || old.getStatus()==2 || old.getStatus()==4){
            this.baseMapper.updateById(record);
            //记录操作日志
            if(check)setApprovalLog(record.getId(),record.getProjectId(),record.getStatus(),"",record.getApprovalResults());
            if (BeanUtils.isNotEmpty(record.getIds())){
                universalWayManager.attachmentUpdates(record.getIds(), record.getId());
            }
        }else{
            throw new ApplicationException("已开始审核不能修改！");
        }
        return record.getId();
    }

    @Override
    @Transactional
    public void updateAuditStatus(BizReformDemandAssignmentRecord record) {
        if (record.getStatus().equals(5)){
            assignmentManager.updateDemandStatus(record.getProjectId(),record.getPropulsiveStatus());
        }
        //判断是否满足记录操作日志条件,避免重复记录
        BizReformDemandAssignmentRecord entity = super.getOne(
                new QueryWrapper<BizReformDemandAssignmentRecord>()
                        .eq("ID_", record.getId())
                        .eq("IS_DELE_", "0"), false);
        boolean check=entity==null||entity.getStatus()!=record.getStatus();
        this.baseMapper.updateById(record);
        //记录操作日志
        if(check)setApprovalLog(record.getId(),record.getProjectId(),record.getStatus(),record.getApprovalComments(),record.getApprovalResults());
    }

    /**
     * 设置审批日志实体类录入
     *
     * @param id
     * @param status
     */
    @Transactional
    public void setApprovalLog(String id,String projectId, Integer status,String approvalComments,Integer approvalResults) {
        // 审批日志
        BizReformDemandAssignment assignment =  this.assignmentManager.getById(projectId);
        String title = assignment.getDemandTopic();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("2");
        logVo.setApprovalComments(approvalComments);
        logVo.setModuleTableName("biz_reform_demand_assignment_record");

        //审核状态0：草稿，1：已录入待更新，2：审核驳回，3：审核通过改革办待审核 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成
        if(approvalResults!=null&&approvalResults==2){
            if(status==0){
                logVo.setItemTitle("【"+title+"】撤回为草稿");
                logVo.setOperateInfo("撤回为草稿！");
            }else if(status==1){
                logVo.setItemTitle("【"+title+"】撤回为提交未审核");
                logVo.setOperateInfo("撤回为提交未审核");
            }else if(status==3){
                logVo.setItemTitle("【"+title+"】撤回为审核通过");
                logVo.setOperateInfo("撤回为审核通过");
            }
            logVo.setApprovalResults(2);
        }else {
            if(status==0){
                logVo.setItemTitle("【"+title+"】录入！");
                logVo.setOperateInfo("需求交办推进信息录入！");
                logVo.setApprovalResults(0);
            }else if(status==1){
                logVo.setItemTitle("【"+title+"】推进记录提交审核！");
                logVo.setOperateInfo("提交审核");
                logVo.setApprovalResults(0);
            }else if(status==2){
                logVo.setItemTitle("【"+title+"】推进记录审核驳回！");
                logVo.setOperateInfo("审核驳回");
                logVo.setApprovalResults(1);
            }else if(status==3){
                logVo.setItemTitle("【"+title+"】推进记录审核通过！");
                logVo.setOperateInfo("审核通过");
                logVo.setApprovalResults(0);
            }else if(status==4){
                logVo.setItemTitle("【"+title+"】推进记录改革办驳回！");
                logVo.setOperateInfo("改革办驳回");
                logVo.setApprovalResults(1);
            }else if(status==5){
                logVo.setItemTitle("【"+title+"】推进记录改革办通过！");
                logVo.setOperateInfo("改革办通过");
                logVo.setApprovalResults(0);
            }
        }
        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateDate(LocalDateTime.now());
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }
}
