package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.fill.dao.BizMeetingEventDetailsDao;
import com.artfess.reform.fill.manager.BizMeetingEventDetailsManager;
import com.artfess.reform.fill.manager.BizMeetingEventDetailsUnitManager;
import com.artfess.reform.fill.manager.BizMeetingEventPushManager;
import com.artfess.reform.fill.manager.BizSpecialGroupManager;
import com.artfess.reform.fill.model.BizMeetingEventDetails;
import com.artfess.reform.fill.model.BizMeetingEventDetailsUnit;
import com.artfess.reform.fill.model.BizMeetingEventPush;
import com.artfess.reform.fill.model.BizSpecialGroup;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.JsonNode;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.*;


/**
 * @Description:会议议定事项详情表 服务实现类
 * @Author: Rong Tao
 * @Date: 2023/4/3 17:15
 */
@Service
public class BizMeetingEventDetailsManagerImpl extends BaseManagerImpl<BizMeetingEventDetailsDao, BizMeetingEventDetails> implements BizMeetingEventDetailsManager {

    @Resource
    FileManager fileManager;

    @Resource
    private BizMeetingEventPushManager bizMeetingEventPushManager;

    @Resource
    private SysDictionaryDetailManager sysDictionaryDetailManager;

    @Resource
    private BizSpecialGroupManager bizSpecialGroupManager;

    @Resource
    private BizMeetingEventDetailsUnitManager bizMeetingEventDetailsUnitManager;



    @Override
    @Transactional
    public void saveOrUpdateList(List<BizMeetingEventDetails> bizMeetingEventDetailsList) {
        super.saveOrUpdateBatch(bizMeetingEventDetailsList);
    }


    @Override
    @Transactional
    public void saveOrUpdateEntity(BizMeetingEventDetails BizMeetingEventDetails) {
        super.saveOrUpdate(BizMeetingEventDetails);
    }

    @Override
    public PageList<BizMeetingEventDetails> queryByPage(QueryFilter<BizMeetingEventDetails> queryFilter,boolean isAffirm) {
        if(!ContextUtil.getCurrentUser().isAdmin()&&!isAffirm){
            queryFilter.addFilter("u.UNIT_ID_", ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        }
        queryFilter.addFilter("e.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("e.SEND_STATUS_",1,QueryOP.EQUAL);
        queryFilter.addFilter("u.UNIT_TYPE_","1",QueryOP.EQUAL);
        IPage<BizMeetingEventDetails> result = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizMeetingEventDetails detailedById(String id) {
        BizMeetingEventDetails result = super.getById(id);
        QueryWrapper<BizMeetingEventPush> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("DETAILS_ID_",id).eq("IS_DELE_","0");
        List<BizMeetingEventPush> list = bizMeetingEventPushManager.list(queryWrapper);
        if(BeanUtils.isNotEmpty(list) && list.size()>0){
            list.stream().forEach(s->s.setFiles(fileManager.queryFileByBizId(s.getId())));
        }
        result.setBizMeetingEventPushList(list);
        return result;
    }

    @Override
    @Transactional
    public boolean modifyStatus(String ids, String status) {
        UpdateWrapper<BizMeetingEventDetails> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("ABUTMENT_STATUS_",status).in("ID_", Arrays.asList(ids.split(",")));
        return super.update(updateWrapper);
    }

    @Override
    public void exportExcel(HttpServletResponse response, QueryFilter<BizMeetingEventDetails> queryFilter,boolean isAffirm) throws Exception {
        List<Map<String, Object>> list = new ArrayList<>();
        queryFilter.addFilter("e.IS_DELE_","0",QueryOP.EQUAL);
        queryFilter.addFilter("u.UNIT_TYPE_",1,QueryOP.EQUAL);
        queryFilter.addFilter("e.SEND_STATUS_",1,QueryOP.EQUAL);
        if (!ContextUtil.getCurrentUser().isAdmin()&&!isAffirm){
            queryFilter.addFilter("u.UNIT_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        }
        IPage<BizMeetingEventDetails> iPage = baseMapper.exportExcel(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        PageList<BizMeetingEventDetails> pageList = new PageList<>(iPage);
        if (BeanUtils.isNotEmpty(pageList.getRows())) {
            pageList.getRows().stream().forEach(p -> {
                try {
                    String jsonStr = JsonUtil.toJson(p);
                    Map<String, Object> map = JsonUtil.toMap(jsonStr);
                    //推进状态
                    if (map.get("pushStatus") != null) {
                        String pushStatus = map.get("pushStatus").toString();
                        String pushStatusText = sysDictionaryDetailManager.getTextByValue("tjzt", pushStatus);
                        map.put("pushStatusText", pushStatusText);
                    } else {
                        map.put("pushStatusText", "");
                    }

                    if (map.get("feedbackTimeLimit") == null) {
                        String updateRate = map.get("updateRate").toString();
                        String gxpl = sysDictionaryDetailManager.getTextByValue("gxpl", updateRate);
                        map.put("feedbackTimeLimitOrUpdateRate",gxpl);
                    }else {
                        map.put("feedbackTimeLimitOrUpdateRate", map.get("feedbackTimeLimit"));
                    }

                    if (map.get("status") != null) {
                        String status = map.get("status").toString();
                        String statusText = sysDictionaryDetailManager.getTextByValue("hy_shzt", status);
                        map.put("statusText", statusText);
                    } else {
                        map.put("statusText", "");
                    }

                    if (map.get("groupName") != null){
                        String groupName = map.get("groupName").toString();
                        JsonNode node = JsonUtil.toJsonNode(groupName);
                        String groupNameText = node.findValues("groupName").toString();
                        String groupTypeText = node.findValues("groupType").toString();
                        String reGroupNameText = groupNameText.replace("\"", "").replace("[", "").replace("]", "").replace(" ","");
                        String reGroupTypeText = groupTypeText.replace("\"", "").replace("[", "").replace("]", "").replace(" ", "");
                        List<String> nameList = Arrays.asList(reGroupNameText.split(","));
                        String type = Arrays.asList(reGroupTypeText.split(",")).get(0);
                        List<BizSpecialGroup> groupList = bizSpecialGroupManager.list(new QueryWrapper<BizSpecialGroup>().eq("GROUP_TYPE_", type));
                        if (nameList.size()==groupList.size()) {
                            if(groupList.get(0).getGroupType()==1){
                                map.put("groupNameText","各专题组");
                            }else {
                                map.put("groupNameText","各专项小组");
                            }
                        } else {
                            map.put("groupNameText",reGroupNameText);
                        }
                    }
                    list.add(map);
                } catch (Exception e) {
                    throw new RuntimeException("导出失败：" + e.getMessage());
                }
            });
            String tempName = "交办事项";
            Map<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("meetingName", "会议名称");
            exportMaps.put("meetingTime", "会议时间");
            exportMaps.put("meetingTask", "重点工作/领导讲话");
            exportMaps.put("specificTask", "具体任务");
            exportMaps.put("groupNameText", "专项小组(专题组)");
            exportMaps.put("unitName", "对接落实责任单位");
            exportMaps.put("cooperativeUnitName", "配合单位");
            exportMaps.put("feedbackTimeLimitOrUpdateRate","反馈时限(更新频率)");
            exportMaps.put("pushStatusText", "推进状态");
            exportMaps.put("measures", "已开展工作及成效");
            exportMaps.put("progress", "存在的问题及困难");
            exportMaps.put("workPlan", "下步工作计划");
            exportMaps.put("statusText", "审核状态");
            HSSFWorkbook book = ExcelUtil.exportExcel(tempName, 24, exportMaps, list);
            ExcelUtil.downloadExcel(book, tempName, response);
        }
    }

    @Override
    @Transactional
    public boolean deleteInfo(String id) {
        Assert.notNull(id,"需要删除的id不能为空");
        bizMeetingEventPushManager.remove(new QueryWrapper<BizMeetingEventPush>().eq("DETAILS_ID_",id).eq("IS_DELE_","0"));
        bizMeetingEventDetailsUnitManager.remove(new QueryWrapper<BizMeetingEventDetailsUnit>().eq("EVENT_DETAILS_ID_",id));
        boolean res = super.removeById(id);
        return res;
    }
}
