package com.artfess.reform.fill.manager.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.manager.BizMeetingDocumentsConsideredManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizMeetingDocumentsConsidered;
import com.artfess.reform.fill.model.BizMeetingDocumentsPush;
import com.artfess.reform.fill.dao.BizMeetingDocumentsPushDao;
import com.artfess.reform.fill.manager.BizMeetingDocumentsPushManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 会议审议通过文件处理推进表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-04-03
 */
@Service
public class BizMeetingDocumentsPushManagerImpl extends BaseManagerImpl<BizMeetingDocumentsPushDao, BizMeetingDocumentsPush> implements BizMeetingDocumentsPushManager {
  @Resource
  private SysDictionaryManager sysDictionaryManager;
  @Resource
  private AchieveStatusLogManager achieveStatusLogManager;
  @Resource
  private BizMeetingDocumentsConsideredManager bizMeetingDocumentsConsideredManager;
  @Resource
  private UniversalWayManager universalWayManager;

    @Override
    @Transactional
    public boolean updateByStatus(BizMeetingDocumentsConsidered bizMeetingDocumentsConsidered) {
        //判断修改的是否等于之前的
        BizMeetingDocumentsPush entity = super.getById(bizMeetingDocumentsConsidered.getPushId());
        boolean check=true;
        if (entity!=null&&entity.getStatus()!=null)
            check=entity.getStatus().equals(bizMeetingDocumentsConsidered.getStatus());
        //根据id，更新审核状态
        boolean update = this.update(new UpdateWrapper<BizMeetingDocumentsPush>()
                .eq("ID_", bizMeetingDocumentsConsidered.getPushId())
                .eq("IS_DELE_", "0")
                .set("STATUS_", bizMeetingDocumentsConsidered.getStatus()));
        //记录操作日志
        if (!check)setApprovalLog(bizMeetingDocumentsConsidered.getPushId(),bizMeetingDocumentsConsidered.getApprovalResults(),bizMeetingDocumentsConsidered.getStatus(),bizMeetingDocumentsConsidered.getApprovalComments());
        return update;
    }

    @Override
    @Transactional
    public boolean insertInfo(BizMeetingDocumentsPush bizMeetingDocumentsPush) {
        Assert.notNull(bizMeetingDocumentsPush.getUnitId(),"主责单位id不能为空");
        //添加实体类
        boolean save = super.save(bizMeetingDocumentsPush);
        //添加附件
        universalWayManager.attachmentUpdates(bizMeetingDocumentsPush.getIds(),bizMeetingDocumentsPush.getId());
        //记录操作日志
        setApprovalLog(bizMeetingDocumentsPush.getId(),bizMeetingDocumentsPush.getApprovalResults(),bizMeetingDocumentsPush.getStatus(),bizMeetingDocumentsPush.getApprovalComments());
        return save;
    }

    @Override
    @Transactional
    public void updateInfo(BizMeetingDocumentsPush bizMeetingDocumentsPush) {

        Assert.notNull(bizMeetingDocumentsPush.getId(),"id不能为空");

        //判断是否满足记录操作日志,避免重复记录
        boolean check = check(bizMeetingDocumentsPush);
        //更新实体类
        super.update(bizMeetingDocumentsPush);
        //根据条件判断是否记录
        if (check) setApprovalLog(bizMeetingDocumentsPush.getId(),bizMeetingDocumentsPush.getApprovalResults(),bizMeetingDocumentsPush.getStatus(),bizMeetingDocumentsPush.getApprovalComments());
        //修改附件
        universalWayManager.attachmentUpdates(bizMeetingDocumentsPush.getIds(),bizMeetingDocumentsPush.getId());
    }

    private void setApprovalLog(String id,Integer approvalResults,Integer status,String approvalComments){
        // 审批日志
        BizMeetingDocumentsPush entity = baseMapper.selectOne(new QueryWrapper<BizMeetingDocumentsPush>().eq("ID_", id).eq("IS_DELE_", "0").last("LIMIT 1"));
        BizMeetingDocumentsConsidered model = bizMeetingDocumentsConsideredManager.getOne(new QueryWrapper<BizMeetingDocumentsConsidered>().eq("ID_", entity.getMeetingId()).eq("IS_DELE_", "0").last("LIMIT 1"));
        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("hy_shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("9");
        logVo.setModuleTableName("BIZ_MEETING_DOCUMENTS_PUSH");
        if (BeanUtils.isNotEmpty(approvalResults)&&approvalResults==2){
            if(status==0){
                logVo.setItemTitle("【"+model.getMeetingName()+"】撤回为草稿");
                logVo.setOperateInfo("撤回为草稿");
            }else if (status==1){
                logVo.setItemTitle("【"+model.getMeetingName()+"】撤回为本级审核");
                logVo.setOperateInfo("撤回为本级审核");
            }else if (status==3){
                logVo.setItemTitle("【"+model.getMeetingName()+"】撤回为本级审核通过");
                logVo.setOperateInfo("撤回为本级审核通过");
            }
            logVo.setApprovalResults(2);
        }else {
            if (status%2==0&&status!=0){
                logVo.setApprovalResults(1);
            }else {
                logVo.setApprovalResults(0);
            }
            if(status==0){
                logVo.setItemTitle("【"+model.getMeetingName()+"】创建录入");
            }else {
                logVo.setItemTitle("【"+model.getMeetingName()+"】"+BizUtils.getDicValueByCode(shzt, status));
            }
            logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, status));
        }
        logVo.setStatus(status.toString());
        logVo.setApprovalComments(approvalComments);
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    boolean check(BizMeetingDocumentsPush bizMeetingDocumentsPush){
        BizMeetingDocumentsPush entity = super.getOne(new QueryWrapper<BizMeetingDocumentsPush>()
                .eq("ID_",bizMeetingDocumentsPush.getId()),false);
        //判断是否是之前的状态,如果是则不新增
        return entity==null||!entity.getStatus().equals(bizMeetingDocumentsPush.getStatus());
    }
}
