package com.artfess.reform.fill.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.dto.OneThingsDTO;
import com.artfess.reform.fill.model.BizDigitalConstruction;
import com.artfess.reform.fill.model.BizDigitalOneThing;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.fill.vo.OneThingsVo;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

/**
 * 围绕重点领域策划推出“一件事”情况 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
public interface BizDigitalOneThingManager extends BaseManager<BizDigitalOneThing> {
    List<BizDigitalOneThing> selectByUnitId(String unitId);
    List<BizDigitalOneThing> selectAuditById(String id);
    List<BizDigitalOneThing> selectExamineById(String id,String unitId);
    PageList<BizDigitalOneThing> queryByPage(QueryFilter<BizDigitalOneThing> queryFilter);
    PageList<BizDigitalOneThing> queryByPageAll(QueryFilter<BizDigitalOneThing> queryFilter);
    PageList<BizDigitalOneThing> queryByPageNew(QueryFilter<BizDigitalOneThing> queryFilter);
    PageList<BizDigitalOneThing> queryByPageHis(OneThingsDTO dto);
}
