package com.artfess.reform.fill.dao;

import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.vo.DemandAssignmentVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;

/**
 * 改革需求分析-需求交办表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
public interface BizReformDemandAssignmentDao extends BaseMapper<BizReformDemandAssignment> {

    /**
     * @Description: 录入页面的分页查询
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BizReformDemandAssignment> queryPageList(IPage<BizReformDemandAssignment> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformDemandAssignment> convert2Wrapper);

    /**
     * @Description: 分页查询审核列表
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BizReformDemandAssignment> queryAudit(IPage<BizReformDemandAssignment> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformDemandAssignment> convert2Wrapper);

    /**
     * @Description: 分页查询最新的推进情况
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<DemandAssignmentVo> queryDemandAssignment(IPage<BizReformDemandAssignment> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformDemandAssignment> convert2Wrapper);


}
