package com.artfess.reform.fill.dao;

import com.artfess.reform.fill.model.BizMeetingEvent;
import com.artfess.reform.fill.model.BizMeetingEventDetails;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * @Description:会议议定事项详情表 Mapper 接口
 * @Author: Rong Tao
 * @Date: 2023/4/3 17:14
 */
public interface BizMeetingEventDetailsDao extends BaseMapper<BizMeetingEventDetails> {

    /**
     * 分页查询所有数据
     * @param convert2iPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizMeetingEventDetails> queryByPage(IPage<BizMeetingEventDetails> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizMeetingEventDetails> convert2Wrapper);

    /**
     * excel导出功能
     * @param convert2iPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizMeetingEventDetails> exportExcel(IPage<BizMeetingEventDetails> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizMeetingEventDetails> convert2Wrapper);

}
