package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.reform.fill.dto.MentDTO;
import com.artfess.reform.fill.manager.*;
import com.artfess.reform.fill.model.BizPilotAdvanceRecord;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.vo.InvVO;
import com.artfess.reform.fill.vo.OperateUserVo;
import com.artfess.reform.fill.vo.StateVO;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


@RestController
@RequestMapping("biz/bizReformPilotManagement/v1")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "改革试点管理")
@Slf4j
public class BizReformPilotManagementController extends BaseController<BizReformPilotManagementManager,BizReformPilotManagement> {

    @PostMapping("/saveQuery")
    @ApiOperation(value = "S-保存数据")
    public CommonResult<String> saveQuery(@ApiParam(name = "BizReformPilotManagement对象") @RequestBody BizReformPilotManagement bizReformPilotManagement) {
        //判断文号是否存在
        if (!baseService.ifExists(bizReformPilotManagement.getDocNo())) {
            new CommonResult<>(false, "该文号已存在,请勿重新输入");
        }
        boolean res = baseService.insertInfo(bizReformPilotManagement);
        return new CommonResult<>(res ? "添加成功" : "添加失败");
    }

    @PostMapping("/updateQuery")
    @ApiOperation(value = "S-修改数据")
    public CommonResult<String> updateQuery(@ApiParam(name = "BizReformPilotManagement对象") @RequestBody BizReformPilotManagement bizReformPilotManagement) {
        baseService.updateInfo(bizReformPilotManagement);
        return new CommonResult<>(true, "修改成功");
    }

    @PostMapping("/updateById")
    @ApiOperation(value = "S-根据修改状态")
    public CommonResult<String> updateById(@RequestBody StateVO stateVo) {
        baseService.updateByStatus(stateVo);
        return new CommonResult<>(true, "修改状态成功");
    }

    @PostMapping("/removeQuery/{ids}")
    @ApiOperation(value = "S-根据id删除数据，多个用,隔开")
    public CommonResult<String> removeQuery(@PathVariable String ids) {
        baseService.removeInfo(ids);
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/queryInput")
    @ApiOperation(value = "S-试点项目录入流程查询")
    public CommonResult<PageList<BizReformPilotManagement>>queryList(@RequestBody MentDTO dto) {
         return new CommonResult<>(true,"查询成功",baseService.queryInput(dto));
    }

    @PostMapping("/disQuery")
    @ApiOperation(value = "S-区县录入审核查询")
    public CommonResult<PageList<BizReformPilotManagement>> disQueryList(@RequestBody QueryFilter<BizReformPilotManagement> queryFilter) {
        return new CommonResult<>(true,"查询成功",baseService.disQueryList(queryFilter));
    }

    @PostMapping("/pilQuery")
    @ApiOperation(value = "S-市级部门确认分发查询")
    public CommonResult<PageList<BizReformPilotManagement>> pilQueryList(@RequestBody QueryFilter<BizReformPilotManagement> queryFilter) {
        return new CommonResult<>(true,"查询成功",baseService.pilQueryList(queryFilter));
    }

    @PostMapping("/invPush")
    @ApiOperation(value = "S-区县项目推进更新")
    public CommonResult<PageList<InvVO>> invsPush(@RequestBody MentDTO mentDTO,boolean isAffirm) {
        return new CommonResult<>(true,"查询成功",baseService.invPush(mentDTO,isAffirm));
    }

    @PostMapping("/invAudit")
    @ApiOperation(value = "S-区县项目推进审核")
    public CommonResult<PageList<InvVO>> pilQueryList(@RequestBody MentDTO mentDTO) {
        return new CommonResult<>(true,"查询成功",baseService.invAudit(mentDTO));
    }

    @PostMapping("/pilAudit")
    @ApiOperation(value = "S-区县项目推进确认")
    public CommonResult<PageList<InvVO>> invAudit(@RequestBody MentDTO mentDTO) {
        return new CommonResult<>(true,"查询成功",baseService.pilAudit(mentDTO));
    }

    @PostMapping("/munAudit")
    @ApiOperation(value = "S-区县项目推进核准")
    public CommonResult<PageList<InvVO>> munAudit(@RequestBody MentDTO mentDTO) {
        return new CommonResult<>(true,"查询成功",baseService.munAudit(mentDTO));
    }

    @PostMapping("/munInfo")
    @ApiOperation(value = "S-改革办修改项目权限")
    public CommonResult<PageList<BizReformPilotManagement>> munInfo(@RequestBody QueryFilter<BizReformPilotManagement> queryFilter) {
        return new CommonResult<>(true,"查询成功",baseService.munInfo(queryFilter));
    }

    @PostMapping("/ifExist")
    @ApiOperation("S-判断该文号是否存在")
    public Boolean ifExist(@RequestParam("docNo")String docNo){
        return baseService.ifExists(docNo);
    }

    @PostMapping("/findModel")
    @ApiOperation("S-根据id查询推进记录")
    public CommonResult<BizPilotAdvanceRecord> findModel(@RequestParam("id")String id){
        BizPilotAdvanceRecord model = baseService.findModel(id);
        return new CommonResult<>(true,"查询成功",model);

    }

    @PostMapping("/findModelHis")
    @ApiOperation("S-根据项目id查询审核历史")
    public CommonResult<List<BizPilotAdvanceRecord>> findModelHis(@RequestParam("id") String id, @RequestParam("unitId") String unitId) {
        List<BizPilotAdvanceRecord> modelHis = baseService.findByHis(id, unitId);
        return new CommonResult<>(true, "查询成功", modelHis);
    }

    @PostMapping(value = "pilotExport", produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出改革试点列表", httpMethod = "POST", notes = "导出改革试点列表")
    public void pilotExport(HttpServletResponse response, @ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody MentDTO mentDTO) throws Exception {
        baseService.pilotExport(response, mentDTO);
    }

    @PostMapping("/findById/{id}")
    @ApiOperation("S-查询试点项目录入详情")
    public BizReformPilotManagement findById(@PathVariable String id) {
        return baseService.findById(id);
    }

    @PostMapping("/auditRemoveInfo")
    @ApiOperation("S-根据角色赋予删除条件")
    public CommonResult<String> auditRemoveInfo(@RequestParam("ids") String ids, @RequestParam(value = "isAffirm", required = true) Boolean isAffirm) {
        baseService.auditRemoveInfo(ids, isAffirm);
        return new CommonResult<>("删除成功");
    }

    @PostMapping("/inputRevInfo")
    @ApiOperation("S-确认分发撤回权限")
    public CommonResult<String> inputRevInfo(@RequestParam("pid") String pid) {
        boolean info = baseService.inputRevInfo(pid);
        return new CommonResult<>(info, info?"":"区县以对该试点项目推进更新!!!");
    }

    @PostMapping("/distinct")
    @ApiOperation("S-去除重复操作日志")
    public CommonResult<String> distinct() {
        this.baseService.distinct();
        return new CommonResult<>("删除成功");
    }

    @PostMapping(value = "/queryGroup", produces = {"application/json; charset=utf-8"})
    @ApiOperation("专项小组查询对应所属领域信息")
    public PageList<BizReformPilotManagement> queryGroup(@RequestBody QueryFilter<BizReformPilotManagement> queryFilter, @RequestParam(name = "code", required = false) String code) {
        IUser user = ContextUtil.getCurrentUser();
        if (user.isAdmin()) code = null;
        return baseService.queryGroup(queryFilter, code);
    }

    @PostMapping(value = "/updateIterateInfo", produces = {"application/json; charset=utf-8"})
    @ApiOperation("市级部门提交验收时间修改")
    public CommonResult<String> updateIterateInfo(@RequestBody BizReformPilotManagement bizReformPilotManagement) {
        boolean res = baseService.updateIterateInfo(bizReformPilotManagement);
        return new CommonResult<>(res ? "提交成功" : "提交失败");
    }

    @PostMapping(value = "/queryDeleteById/{id}", produces = {"application/json; charset=utf-8"})
    @ApiOperation("根据id查询删除项目的基本信息")
    public BizReformPilotManagement queryDeleteById(@PathVariable("id") String id) {
        return baseService.queryDeleteById(id);
    }

    @PostMapping(value = "/operateDeleteById/{id}", produces = {"application/json; charset=utf-8"})
    @ApiOperation("根据id查询删除项目的人员及联系方式")
    public OperateUserVo operateDeleteById(@PathVariable("id") String id) {
        return baseService.operateDeleteById(id);
    }
}
