package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.dto.MentDTO;
import com.artfess.reform.fill.manager.BizReformPilotCityManagementManager;
import com.artfess.reform.fill.model.BizPilotAdvanceCityRecord;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizReformPilotCityManagement;

import javax.servlet.http.HttpServletResponse;

/**
 * 改革试点市级部门管理表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@RestController
@RequestMapping("/fill/bizReformPilotCityManagement/v1/")
@Api(tags = "市级部门试点管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizReformPilotCityManagementController extends BaseController<BizReformPilotCityManagementManager, BizReformPilotCityManagement> {

    @PostMapping("/saveOrUpdateInfo")
    @ApiOperation(value = "S-保存数据或者修改数据")
    public CommonResult<String> saveOrUpdateInfo(@ApiParam(name = "BizReformPilotManagement对象") @RequestBody BizReformPilotCityManagement entity) {
        //判断文号是否存在
        if (!baseService.isSameExists(entity.getId(),entity.getDocNo())) {
            new CommonResult<>(false, "该文号已存在,请勿重新输入");
        }
        String id = entity.getId();
        boolean res = baseService.saveOrUpdateInfo(entity);
        if (id!=null){
            return new CommonResult<>(res?"修改成功":"修改失败");
        }else {
            return new CommonResult<>(res?"添加成功":"添加失败");
        }
    }

    @PostMapping("/deleteInfo")
    @ApiOperation(value = "S-删除数据")
    public CommonResult<String> deleteInfo(@ApiParam(name = "需要删除的id,如有多个用，隔开") @RequestParam(value = "ids") String ids, @RequestParam(value = "isAffirm") boolean isAffirm) {
        baseService.deleteInfo(ids,isAffirm);
        return new CommonResult<>("删除成功");
    }

    @PostMapping("/updateByStatus")
    @ApiOperation(value = "S-修改审核状态")
    public CommonResult<String> updateByStatus(@ApiParam(name = "BizPilotAdvanceCityRecord对象") @RequestBody BizPilotAdvanceCityRecord entity) {
        boolean res = baseService.updateByStatus(entity);
        return new CommonResult<>(res?"修改审核状态成功":"修改审核状态失败");
    }

    @PostMapping("/queryPage")
    @ApiOperation(value = "S-分页查询")
    public PageList<BizReformPilotCityManagement> queryPage(@ApiParam("通用查询器")@RequestBody QueryFilter<BizReformPilotCityManagement> queryFilter,@RequestParam("isAffirm") boolean isAffirm) {
        return baseService.queryPage(queryFilter,isAffirm);
    }

    @PostMapping("/queryGroupPage")
    @ApiOperation(value = "S-专项小组分页查询")
    public PageList<BizReformPilotCityManagement> queryGroupPage(@ApiParam("通用查询器")@RequestBody QueryFilter<BizReformPilotCityManagement> queryFilter) {
        return baseService.queryGroupPage(queryFilter);
    }

    @PostMapping("/isSameExists")
    @ApiOperation(value = "S-验证文号唯一性")
    public boolean isSameExists(@RequestParam(value = "id",required = false)String id,@RequestParam(value = "docNo")String docNo) {
       return baseService.isSameExists(id, docNo);
    }

    @RequestMapping(value = "pilotExport", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出改革试点列表", httpMethod = "POST", notes = "导出改革试点列表")
    public void pilotExport(HttpServletResponse response, @ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<BizReformPilotCityManagement> queryFilter) throws Exception {
        baseService.pilotExport(response,queryFilter);
    }

    @PostMapping(value="/updateIterateInfo", produces={"application/json; charset=utf-8"})
    @ApiOperation("市级部门修改验收时间")
    public CommonResult<String> updateIterateInfo(@RequestBody BizReformPilotCityManagement bizReformPilotCityManagement) {
        String id = baseService.updateIterateInfo(bizReformPilotCityManagement);
        return CommonResult.success(id,id!=null?"提交成功":"提交失败");
    }
}
