package com.artfess.reform.statistics.schedule;

import com.artfess.reform.statistics.manager.BizScoringProjectBrandManager;
import com.artfess.reform.statistics.manager.BizScoringProjectIterationManager;
import com.artfess.reform.statistics.manager.BizScoringProjectMeasureManager;
import com.artfess.reform.statistics.manager.BizScoringProjectSynManager;
import com.artfess.reform.statistics.manager.BizScoringProjectTargetManager;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;

@Component
@EnableScheduling
public class ProjectSchedule {

    @Resource
    private BizScoringProjectTargetManager bizScoringProjectTargetManager;

    @Resource
    private BizScoringProjectBrandManager bizScoringProjectBrandManager;

    @Resource
    private BizScoringProjectMeasureManager bizScoringProjectMeasureManager;

    @Resource
    private BizScoringProjectIterationManager bizScoringProjectIterationManager;

    @Resource
    private BizScoringProjectSynManager bizScoringProjectSynManager;


    //计算市重大项目量化目标推进力评分、品牌显示度、具体措施推进力、综合评分结果
    @Scheduled(cron = "0 55 23 * * ?")
    public void scheduleProjectScore(){
        LocalDate countDate =LocalDate.now();
//        //量化目标推进力评分
//        bizScoringProjectTargetManager.countScore(countDate);
//        //品牌显示度评分
//        bizScoringProjectBrandManager.countScore(countDate);
        //具体措施推进力评分
//        bizScoringProjectMeasureManager.countScore(countDate);
        //综合评分
        bizScoringProjectSynManager.countScore(countDate);
    }

    //计算市重大项目具体举措迭代数据
//    @Scheduled(cron = "0 45 23 * * ?")
//    public void scheduleProjectIteration(){
//        LocalDate countDate =LocalDate.now();
//        bizScoringProjectIterationManager.countScore(countDate);
//    }


}
