package com.artfess.reform.statistics.dao;

import com.artfess.reform.statistics.model.BizScoringProjectIteration;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目具体举措迭代统计表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-15
 */
public interface BizScoringProjectIterationDao extends BaseMapper<BizScoringProjectIteration> {

    /**
    * @Description: 根据时间统计迭代次数
    * @param fillYear 迭代年份
    * @param fillQuarter 迭代季度
    * @param fillMonth  迭代月份
    * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringProjectIteration>
    * @Author: chens
    * @Date: 2023/3/29 11:38
    */
    List<BizScoringProjectIteration> queryIterationByDate(@Param("fillYear") Integer  fillYear, @Param("fillQuarter") Integer  fillQuarter,  @Param("fillMonth") Integer  fillMonth);
}
