package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;

import java.time.LocalDate;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 其他改革成果（进度计划明细推进情况）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@TableName("BIZ_PILOT_SPECIFIC_SCHEDULE_PUSH")
@ApiModel(value="BizPilotSpecificSchedulePush对象", description="其他改革成果（进度计划明细推进情况）")
public class PilotSpecificSchedulePush extends AutoFillFullModel<PilotSpecificSchedulePush> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据ID")
    @TableField(exist = false)
    private String dataId;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "填报ID（关联市级重大改革项目填报审核记录表ID）")
    @TableField("FILL_ID_")
    private String fillId;

    @ApiModelProperty(value = "进度计划ID（关联进度计划表ID）")
//    @TableField("OBJECTIVES_MEASURES_ID_")
    @TableField(exist = false)
    private String objectivesMeasuresId;

    @ApiModelProperty(value = "进行状态（1：未开始，2：进行中，3：已完成）")
    @TableField("PROGRESS_STATUS_")
    private Integer progressStatus;

    @ApiModelProperty(value = "举措明细计划类型（1：形成制度成果，2：搭建重要平台，3：上线应用场景，4：其他）")
    @TableField("MEASURES_PLAN_TYPE_")
    private Integer measuresPlanType;

    @ApiModelProperty(value = "实际成果的名称")
    @TableField("RESULT_NAME_")
    private String resultName;

    @ApiModelProperty(value = "相关依据")
    @TableField("BASIS_")
    private String basis;

    @ApiModelProperty(value = "形成制度时间")
    @TableField("PUSH_DATE_")
    private LocalDate pushDate;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private String classified;

    @ApiModelProperty(value = "审核状态（与填报表状态一致，0：草稿，1：已录入待审核，2：责任单位领导审核驳回，,3：责任单位领导审核通过，4：市委改革办审核驳回，5：市委改革办审核通过）")
    @TableField("STATUS_")
    private Integer status;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDelete",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    protected String isDele = "0";

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<DefaultFile> defaultFileList;
}
