package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.baomidou.mybatisplus.annotation.*;

import java.time.LocalDate;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 进度计划表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@TableName("BIZ_PILOT_SPECIFIC_SCHEDULE")
@ApiModel(value="BizPilotSpecificSchedule对象", description="进度计划表")
public class PilotSpecificSchedule extends AutoFillFullModel<PilotSpecificSchedule> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "措施ID")
    @TableField("MEASURES_ID_")
    private String measuresId;

    @ApiModelProperty(value = "计划年度")
    @TableField("PLAN_YEAR_")
    private Integer planYear;

    @ApiModelProperty(value = "计划季度")
    @TableField("PLAN_QUARTER_")
    private Integer planQuarter;

    @ApiModelProperty(value = "计划月度")
    @TableField("PLAN_MONTH_")
    private Integer planMonth;

    @ApiModelProperty(value = "计划类型（使用字典，1：形成制度成果，2：搭建重要平台，3：上线应用场景）")
    @TableField("PLAN_TYPE_")
    private Integer planType;

    @ApiModelProperty(value = "计划内容")
    @TableField("PLAN_CONTENT_")
    private String planContent;

    @ApiModelProperty(value = "计划状态（字典：0：草稿，1：正式）")
    @TableField("PLAN_STATUS_")
    private Integer planStatus;

    @ApiModelProperty(value = "进行状态（1：未开始，2：进行中，3：已完成）")
    @TableField("PROGRESS_STATUS_")
    private Integer progressStatus;

    @ApiModelProperty(value = "计划完成时间")
    @TableField("PLANNED_COMPLETION_TIME_")
    private LocalDate plannedCompletionTime;

    @ApiModelProperty(value = "实际完成时间")
    @TableField("ACTUAL_COMPLETION_TIME")
    private LocalDate actualCompletionTime;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDelete",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    protected String isDele = "0";

    @ApiModelProperty(value = "进度计划推进情况集合")
    @TableField(exist = false)
    private List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList;

    @ApiModelProperty(value = "项目名称")
    @TableField(exist = false)
    private String projectName;

    @ApiModelProperty(value = "牵头市领导")
    @TableField(exist = false)
    private String leader;

    @ApiModelProperty(value = "责任单位")
    @TableField(exist = false)
    private String unitName;

    @ApiModelProperty(value = "所属领域")
    @TableField(exist = false)
    private Integer projectField;

    @ApiModelProperty(value = "所属跑道")
    @TableField(exist = false)
    private Integer projectRunWay;

    @ApiModelProperty(value = "状态")
    @TableField(exist = false)
    private Integer status;

    @ApiModelProperty(value = "已开展工作")
    @TableField(exist = false)
    private String completedWork;

    @ApiModelProperty(value = "存在问题")
    @TableField(exist = false)
    private String problems;

    @ApiModelProperty(value = "下一步工作计划")
    @TableField(exist = false)
    private String workPlan;
}
