package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 市级重大改革项目填报审核记录
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
@Data
@TableName("BIZ_PILOT_PROJECT_FILL")
@ApiModel(value="BizPilotProjectFill对象", description="市级重大改革项目填报审核记录")
public class PilotProjectFill extends AutoFillFullModel<PilotProjectFill> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;


    @ApiModelProperty(value = "项目ID")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "流程类型（1：量化目标审核流程2：月度计划审核流程，3：经验推广流程，4：品牌显示度流程）")
    @TableField("FLOW_TYPE_")
    private Integer flowType;

    @ApiModelProperty(value = "填报日期")
    @TableField("FILL_DATE_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "填报年")
    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @ApiModelProperty(value = "填报季度")
    @TableField("FILL_QUARTER_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "填报月")
    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @ApiModelProperty(value = "责任单位ID")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "责任单位NAME（关联组织机构表名称）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "审核状态（使用字典，0：草稿，1：已录入待审核，2：责任单位领导审核驳回，,3：责任单位领导审核通过，4：市委改革办审核驳回，5：市委改革办审核通过）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDelete",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    private String isDele = "0";

    @ApiModelProperty(value = "数据ID")
    @TableField(exist = false)
    private String dataId;

    @ApiModelProperty(value = "项目名称")
    @TableField(exist = false)
    private String projectName;

    @ApiModelProperty(value = "项目类型(1:加快实施一批，2:准备启动一批，3:谋划储备一批)")
    @TableField(exist = false)
    private Integer projectType;

    @ApiModelProperty(value = "牵头市领导")
    @TableField(exist = false)
    private String leader;

    @ApiModelProperty(value = "所属领域（使用字典，1：政治，2：经济，3：文化，4：社会，5：生态）")
    @TableField(exist = false)
    private Integer projectField;

    @ApiModelProperty(value = "所属跑道（使用字典，1：党的建设，2：XX）")
    @TableField(exist = false)
    private Integer projectRunway;

    @ApiModelProperty(value = "驳回意见")
    @TableField(exist = false)
    private String approvalComments;

    @ApiModelProperty(value = "执行结果（0：同意，1：驳回，2：撤回）")
    @TableField(exist = false)
    private Integer approvalResults;

    @ApiModelProperty(value = "本次更新时间")
    @TableField(exist = false)
    private LocalDate thisTime;

    @ApiModelProperty(value = "项目经验推广总结情况")
    @TableField(exist = false)
    private List<PilotExperiencePush> pilotExperiencePushList;

    @ApiModelProperty(value = "项目品牌显示度情况")
    @TableField(exist = false)
    private List<PilotBrandPush> pilotBrandPushList;
}
