package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.reform.majorProjects.model.MouthFieldEnum;
import com.artfess.reform.majorProjects.model.PilotObjectivesDetails;
import com.artfess.reform.majorProjects.dao.PilotObjectivesDetailsDao;
import com.artfess.reform.majorProjects.manager.PilotObjectivesDetailsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.utils.CumputeUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 改革方案明确的量化目标的计划值 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-11
 */
@Service
public class PilotObjectivesDetailsManagerImpl extends BaseManagerImpl<PilotObjectivesDetailsDao, PilotObjectivesDetails> implements PilotObjectivesDetailsManager {

    @Override
    public PilotObjectivesDetails getDetailsByYearAndObjectivesMeasuresId(Integer pushYear, String objectivesMeasuresId) {
        QueryWrapper<PilotObjectivesDetails> pilotObjectivesDetailsQueryWrapper = new QueryWrapper<>();
        pilotObjectivesDetailsQueryWrapper.eq(StringUtils.isNotBlank(objectivesMeasuresId),"OBJECTIVES_ID_", objectivesMeasuresId);
        pilotObjectivesDetailsQueryWrapper.eq(pushYear != null, "YEAR_", pushYear);
        List<PilotObjectivesDetails> list = this.list(pilotObjectivesDetailsQueryWrapper);
        if(null != list && list.size() > 0){
            return  list.get(0);
        }
        return null;
    }

    @Override
    public BigDecimal getYearValue(Integer pushYear, String objectivesMeasuresId) {
        PilotObjectivesDetails detailsByYearAndObjectivesMeasuresId = this
                .getDetailsByYearAndObjectivesMeasuresId(pushYear, objectivesMeasuresId);
        if(null != detailsByYearAndObjectivesMeasuresId){
            return detailsByYearAndObjectivesMeasuresId.getYearValue();
        }
        return null;
    }


    public BigDecimal getMonthValue(Integer pushYear, Integer pushMonth, String objectivesMeasuresId) {
        PilotObjectivesDetails detailsByYearAndObjectivesMeasuresId = this.getDetailsByYearAndObjectivesMeasuresId(pushYear, objectivesMeasuresId);
        if(null != detailsByYearAndObjectivesMeasuresId){
            Map map = BeanUtils.beanToMap(detailsByYearAndObjectivesMeasuresId);
            Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(pushMonth)));
            if(o!=null){
                 BigDecimal mouthValue = (BigDecimal) o;
                return mouthValue;
            }
        }
        return null;
    }


}
