package com.artfess.reform.majorProjects.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasures;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasuresHistory;
import com.artfess.reform.majorProjects.vo.IterationEntityVO;
import com.artfess.reform.majorProjects.vo.IterationExamine;
import com.artfess.reform.majorProjects.vo.IterationExamineAndProjectVo;

import java.util.List;

/**
 * 改革方案明确的具体举措表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
public interface PilotSpecificMeasuresManager extends BaseManager<PilotSpecificMeasures> {

    /**
     * 根据项目ID查询举措集合
     * @param projectId 项目ID
     * @return
     */
    List<PilotSpecificMeasures> queryListByProjectId(String projectId);

    /**
     * 根据举措信息进行迭代提交审核
     * @param pilotSpecificMeasuresList
     */
    void iterationSaveAndCommit(List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList);

    /**
     * 根据已保存的迭代 举措信息进行提交审核
     * @param iteration
     */
    void iterationCommit(IterationExamine iteration);

    /**
     * 根据举措信息进行迭代 保存，还未提交进行审核
     * @param pilotSpecificMeasuresList
     */
    void iterationSave(List<PilotSpecificMeasures> pilotSpecificMeasuresList);

    /**
     * 举措迭代审核列表分页查询
     * @param queryFilter
     * @return
     */
    PageList<IterationExamineAndProjectVo> iterationListByPage(QueryFilter<PilotSpecificMeasuresHistory> queryFilter);

    /**
     * 根据举措信息进行添加 保存或修改草稿
     * @param pilotSpecificMeasuresList
     */
    void iterationAddSave(List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList);


    /**
     * 根据parentID查询举措是否在迭代中
     * @param id
     * @return
     */
    int countPilotSpecificMeasuresByParentId(String id);

    /**
     * 删除举措
     * @param id 举措id
     * @return
     */
    boolean  deleteMeasuresById(String id);
}
