package com.artfess.reform.majorProjects.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.PilotMeasuresPushVo;

import java.util.List;

/**
 * 项目具体举措计划推进情况 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
public interface PilotMeasuresPushManager extends BaseManager<PilotMeasuresPush> {
    /**
     * 根据填报ID查询推进信息
     * @param id 填报ID
     * @param projectId 项目ID
     * @param isHis 是否查询历史数据
     * @return
     */
    List<PilotMeasuresPushVo> queryListByFillId(String id,String projectId,String isHis);

    /**
     * 根据ID统计是否存在推进记录数据
     * @param id
     * @return
     */
    int countPilotMeasuresPushPush(String id);

    /**
     * 根据填报信息修改计划状态
     * @param pilotProjectFill
     */
    void updateStatusByProjectFill(PilotProjectFill pilotProjectFill);


    /**
     * 根据填报ID查询推进信息
     * @return
     */
    PageList<PilotMeasuresPushVo> queryList(QueryFilter<PilotMeasuresPush> queryFilter);

    /**
     * 成果榜查询数据
     * @param queryFilter
     * @return
     */
    PageList<PilotMeasuresPush> achievementInfo(QueryFilter<PilotMeasuresPush> queryFilter);

    /**
     * 成果榜查询详情
     * @param id
     * @return
     */
    PilotMeasuresPush achievementFindById(String id);
}
