package com.artfess.reform.majorProjects.dao;

import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.vo.PilotMeasuresPushVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目具体举措计划推进情况 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
public interface PilotMeasuresPushDao extends BaseMapper<PilotMeasuresPush> {

    /**
     * 项目具体举措计划推进情况集合，包括具体季度的计划
     * @param fillId
     * @return
     */
    List<PilotMeasuresPushVo> queryListByFillId(@Param("fillId") String  fillId,@Param("projectId") String  projectId,@Param("isHis") String  isHis);

    /**
    * 分页查询所有项目的月度计划及其推进情况
    * @Return: java.util.List<com.artfess.reform.majorProjects.vo.PilotMeasuresPushVo>
    * @Author: chens
    * @Date: 2023/5/5 15:40
    */
    IPage<PilotMeasuresPushVo> queryList(IPage<PilotMeasuresPush> convert2iPage, @Param(Constants.WRAPPER) Wrapper<PilotMeasuresPush> convert2Wrapper);

    /**
     * 查询成果榜详细数据
     * @return
     */
//    List<PilotMeasuresPush> achievementInfo(@Param("year") Integer year, @Param("month") Integer month, @Param("type") Integer type);
    IPage<PilotMeasuresPush> achievementInfo(IPage<PilotMeasuresPush> convert2iPage, @Param(Constants.WRAPPER) Wrapper<PilotMeasuresPush> convert2Wrapper);

    /**
     * 重大项目大屏导出总查询-月度计划
     * @param projectId
     * @param year
     * @param month
     * @return
     */
    List<PilotMeasuresPush> pilotMeasuresPushInfo(@Param("projectId")String projectId, @Param("year")Integer year, @Param("month")Integer month);
}
