package com.artfess.reform.fill.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会议通知部门人员表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@TableName("BIZ_MEETING_NOTICE_UNIT_USER")
@ApiModel(value="BizMeetingNoticeUnitUser对象", description="会议通知部门人员表")
@Data
public class BizMeetingNoticeUnitUser extends BaseModel<BizMeetingNoticeUnitUser>{

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议主表id关联各个会议主表")
    @TableField("MEETING_ID_")
    private String meetingId;

    @ApiModelProperty(value = "会议通知部门表id关联会议通知部门表")
    @TableField("MEETING_NOTICE_UNIT_ID_")
    private String meetingNoticeUnitId;

    @ApiModelProperty(value = "单位id（关联组织机构表id）")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "单位name关联组织机构表name")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "单位code关联组织机构表编码")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "单位grade关联组织机构表级别")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "单位")
    @TableField("UNIT_")
    private String unit;

    @ApiModelProperty(value = "姓名")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "职务")
    @TableField("POSITION_")
    private String position;

    @ApiModelProperty(value = "联系电话")
    @TableField("TELEPHONE_")
    private String telephone;

    @ApiModelProperty(value = "车牌号")
    @TableField("LICENSE_PLATE_NUMBER_")
    private String licensePlateNumber;

    @ApiModelProperty(value = "性别使用字典，1：男，2：女")
    @TableField("GENDER_")
    private Integer gender;

    @ApiModelProperty(value = "租户id")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public String getMeetingNoticeUnitId() {
        return meetingNoticeUnitId;
    }

    public void setMeetingNoticeUnitId(String meetingNoticeUnitId) {
        this.meetingNoticeUnitId = meetingNoticeUnitId;
    }

    public String getUnitId() {
        return unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getUnitCode() {
        return unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public String getUnitGrade() {
        return unitGrade;
    }

    public void setUnitGrade(String unitGrade) {
        this.unitGrade = unitGrade;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getLicensePlateNumber() {
        return licensePlateNumber;
    }

    public void setLicensePlateNumber(String licensePlateNumber) {
        this.licensePlateNumber = licensePlateNumber;
    }

    public Integer getGender() {
        return gender;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }


    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "BizMeetingNoticeUnitUser{" +
            "id=" + id +
            ", meetingId=" + meetingId +
            ", meetingNoticeUnitId=" + meetingNoticeUnitId +
            ", unitId=" + unitId +
            ", unitName=" + unitName +
            ", unitCode=" + unitCode +
            ", unitGrade=" + unitGrade +
            ", unit=" + unit +
            ", name=" + name +
            ", position=" + position +
            ", telephone=" + telephone +
            ", licensePlateNumber=" + licensePlateNumber +
            ", gender=" + gender +
            ", tenantId=" + tenantId +
        "}";
    }
}
