package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.util.Date;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 开发上线特色应用情况
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */

@Data
@TableName("BIZ_DIGITAL_ON_LINE_APPLICATION")
@ApiModel(value="BizDigitalOnLineApplication对象", description="开发上线特色应用情况")
public class BizDigitalOnLineApplication extends AutoFillFullModel<BizDigitalOnLineApplication> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "原始数据id")
    @TableField("ORIGINAL_ID_")
    private String originalId;

    @ApiModelProperty(value = "事项名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "所属体系")
    @TableField("APPERTAIN_SYSTEM_")
    private Integer appertainSystem;

    @ApiModelProperty(value = "所属跑道")
    @TableField("APPERTAIN_SUNWAY_")
    private Integer appertainSunway;

    @ApiModelProperty(value = "应用简介")
    @TableField("APPLICATION_INTRODUCTION_")
    private String applicationIntroduction;

    @ApiModelProperty(value = "当前状态")
    @TableField("CURRENT_STATE_")
    private Integer currentState;

    @ApiModelProperty(value = "审核情况")
    @TableField("AUDIT_STATUS_")
    private Integer auditStatus;

    @ApiModelProperty(value = "是否涉密")
    @TableField("CLASSIFIED_")
    private Integer classified;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele="0";

    @ApiModelProperty(value = "移除名录库原因")
    @TableField("CASE_")
    private String removeCase;

    @ApiModelProperty(value = "是否纳入名录库(0:是，1:否)")
    @TableField("IS_BRING_INTO_")
    private Integer isBringInto;

    @ApiModelProperty(value = "入库时间")
    @TableField("AUDIT_TIME_")
    private LocalDateTime auditTime;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<DefaultFile> files;
}
