package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizReformRiskManagement;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;

import java.util.List;

public interface BizReformSatisfactionManagementManager extends BaseManager<BizReformSatisfactionManagement> {

    /**
     * @Description: 分页查询
     * @param queryFilter
     * @Return:
     * @Author: chens
     * @Date: 2023/3/21 13:11
     */
    PageList<BizReformSatisfactionManagement> queryByPage(QueryFilter<BizReformSatisfactionManagement> queryFilter,boolean isAffirm);

    /**
     * @Description: 保存满意度
     * @param bizReformSatisfactionManagement
     * @Return: String id
     * @Author: chens
     * @Date: 2023/3/21 13:11
     */
    String saveOrUpdateSatisfaction(BizReformSatisfactionManagement bizReformSatisfactionManagement);

    /**
    * @Description: 修改审批状态
    * @param id 主表ID
    * @param status  审核状态
    * @param approvalComments  审核意见
    * @Return: void
    * @Author: chens
    * @Date: 2023/3/21 13:29
    */
    void updateStatusById(String id, Integer status,Integer fileStatus,String approvalComments);

    /**
    * @Description: 根据ID查询满意度信息
    * @param id  满意度ID
    * @Return: com.artfess.reform.fill.model.BizReformSatisfactionManagement
    * @Author: chens
    * @Date: 2023/3/21 13:11
    */
    BizReformSatisfactionManagement getById(String id);

    /**
    * @Description: 根据ID批量删除
    * @param id id集合
    * @Return: void
    * @Author: chens
    * @Date: 2023/3/21 13:38
    */
    CommonResult<String> deleteBatchByIds(String id);

    PageList<BizReformSatisfactionManagement> pageList(QueryFilter<BizReformSatisfactionManagement> queryFilter);

    PageList<BizReformSatisfactionManagement> auditQuery(QueryFilter<BizReformSatisfactionManagement> queryFilter);

    PageList<BizReformSatisfactionManagement> reformQuery(QueryFilter<BizReformSatisfactionManagement> queryFilter);
}
