package com.artfess.reform.fill.manager;

import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;
import com.artfess.base.manager.BaseManager;

/**
 * 需求交办推进记录表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
public interface BizReformDemandAssignmentRecordManager extends BaseManager<BizReformDemandAssignmentRecord> {

    /**
    * @Description: 保存
    * @param record  需求交办推进记录表
    * @Return: java.lang.String
    * @Author: chens
    * @Date: 2023/3/22 10:21
    */
    String insertInfo(BizReformDemandAssignmentRecord  record);

    /**
     * @Description: 修改
     * @param record  需求交办推进记录表
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/3/22 10:21
     */
    String updateInfo(BizReformDemandAssignmentRecord  record);

    /**
     * @Description: 修改审核状态
     * @param record  需求交办推进记录表
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/3/22 10:21
     */
    void updateAuditStatus(BizReformDemandAssignmentRecord  record);
}
