package com.artfess.reform.fill.dao;

import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.uc.api.impl.model.Org;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 满意度区县结果表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
public interface BizReformSatisfactionDistrictsDao extends BaseMapper<BizReformSatisfactionDistricts> {

    /**
    * @Description:
    * @param scoringYear
    * @param scoringQuarter
    * @Return: java.util.List<com.artfess.reform.fill.model.BizReformSatisfactionDistricts>
    * @Author: chens
    * @Date: 2023/4/6 13:33
    */
    List<BizReformSatisfactionDistricts>  getAfterQuarterFirst(@Param("scoringYear") Integer scoringYear, @Param("scoringQuarter") Integer scoringQuarter);

    /**
    * @Description: 查询最新的区县满意度信息
    * @Return: java.util.List<com.artfess.reform.fill.model.BizReformSatisfactionDistricts>
    * @Author: chens
    * @Date: 2023/5/31 14:25
    */
    List<BizReformSatisfactionDistricts> countSatisfactForOrg(@Param("year") Integer year,@Param("quarter")  Integer quarter);


    /**
     * @Description: 根据区县编码查询最新的该区县的满意度信息
     * @Return: java.util.List<com.artfess.reform.fill.model.BizReformSatisfactionDistricts>
     * @Author: chens
     * @Date: 2023/5/31 14:25
     */
    BizReformSatisfactionDistricts qureySatisfactionDistrictsByUnitCode(@Param("year")  Integer year,@Param("quarter")  Integer quarter,@Param("unitCode")  String unitCode);

    /**
     * @Description: 根据区县编码查询该区县的5个领域的满意度
     * @Return: java.util.List<com.artfess.reform.fill.model.BizReformSatisfactionDistricts>
     * @Author: chens
     * @Date: 2023/5/31 14:25
     */
    List<BizReformSatisfactionDistricts> qureyFieldByUnitCode(@Param("unitCode")  String unitCode,@Param("scoringYear") Integer scoringYear, @Param("scoringQuarter") Integer scoringQuarter);
}
