package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizReformIteratePilotManagement;
import com.artfess.reform.fill.manager.BizReformIteratePilotManagementManager;

/**
 * 试点迭代管理表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-07-13
 */
@RestController
@RequestMapping("/fill/bizReformIteratePilotManagement/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "改革试点迭代管理")
public class BizReformIteratePilotManagementController extends BaseController<BizReformIteratePilotManagementManager, BizReformIteratePilotManagement> {

    @PostMapping("/query")
    @ApiOperation(value = "S-分页查询迭代信息")
    public PageList<BizReformIteratePilotManagement> queryList(@RequestBody QueryFilter<BizReformIteratePilotManagement> queryFilter) {
        return baseService.queryPageInfo(queryFilter);
    }

    @PostMapping(value="/updateIterateStatus")
    @ApiOperation("修改验收时间时,改革办审核")
    public CommonResult<String> updateIterateStatus(@RequestBody BizReformIteratePilotManagement bizReformIteratePilotManagement) {
        baseService.updateIterateStatus(bizReformIteratePilotManagement);
        return new CommonResult<>("操作成功");
    }

    @Override
    @GetMapping(value="/{id}")
    @ApiOperation("根据id查询实体")
    public BizReformIteratePilotManagement getById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        return baseService.getById(id);
    }
}
