package com.artfess.reform.approvalLog.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 审批意见结果记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-11
 */
@Data
@ApiModel(value="BizAuditResult对象", description="审批意见结果记录表")
@TableName("BIZ_AUDIT_RESULT")
public class AuditResult extends AutoFillFullModel<AuditResult> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "业务数据类型，（1：改革需求业务，2：改革需求交办业务，3：堵点卡点业务，4：成效晾晒比拼，5：改革试点管理，6：市级重大改革项目管理，7：改革满意度管理，8：改革风险管理，9：深改委会议管理）")
    @TableField("BIZ_TYPE_")
    private String bizType;

    @ApiModelProperty(value = "业务数据_ID")
    @TableField("BIZ_ID_")
    private String bizId;

    @ApiModelProperty(value = "工作项标题【需要组合任务生成标题名称】")
    @TableField("ITEM_TITLE_")
    private String itemTitle;

    @ApiModelProperty(value = "发送单位_ID")
    @TableField("SEND_DEPT_ID_")
    private String sendDeptId;

    @ApiModelProperty(value = "发送单位_NAME")
    @TableField("SEND_DEPT_NAME_")
    private String sendDeptName;

    @ApiModelProperty(value = "发送部门_CODE")
    @TableField("SEND_DEPT_CODE_")
    private String sendDeptCode;

    @ApiModelProperty(value = "发送部门_GRADE")
    @TableField("SEND_DEPT_GRADE_")
    private String sendDeptGrade;

    @ApiModelProperty(value = "发送者_ID")
    @TableField("SEND_USER_ID_")
    private String sendUserId;

    @ApiModelProperty(value = "发送者_账号")
    @TableField("SEND_LOGIN_NAME_")
    private String sendLoginName;

    @ApiModelProperty(value = "发送者_NAME")
    @TableField("SEND_USER_NAME_")
    private String sendUserName;

    @ApiModelProperty(value = "发送时间")
    @TableField("SEND_DATE_")
    private LocalDateTime sendDate;

    @ApiModelProperty(value = "计划规定的完成时间")
    @TableField("PLAN_COMPLETE_DATE_")
    private LocalDateTime planCompleteDate;

    @ApiModelProperty(value = "打开系统调用访问的URL应用链接，也可以是本地系统路由地址。访问之后改变状态。")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "优先级（0 一般；1紧急；2 特急；3其他）")
    @TableField("PRIORITY_")
    private Integer priority;

    @ApiModelProperty(value = "执行模式（1：并行操作  2：抢占操作）")
    @TableField("MODE_TYPE_")
    private Integer modeType;

    @ApiModelProperty(value = "审核单位_ID")
    @TableField("REPORT_UNIT_ID_")
    private String reportUnitId;

    @ApiModelProperty(value = "审核单位_NAME")
    @TableField("REPORT_UNIT_NAME_")
    private String reportUnitName;

    @ApiModelProperty(value = "审核单位_CODE")
    @TableField("REPORT_UNIT_CODE_")
    private String reportUnitCode;

    @ApiModelProperty(value = "审核单位_GRADE")
    @TableField("REPORT_UNIT_GRADEE_")
    private String reportUnitGradee;

    @ApiModelProperty(value = "审核者_ID")
    @TableField("REPORT_ID_")
    private String reportId;

    @ApiModelProperty(value = "审核者_NAME")
    @TableField("RECEIVE_NAME")
    private String receiveName;

    @ApiModelProperty(value = "审核者_账号")
    @TableField("RECEIVE_LOGIN_ACCOUNT_")
    private String receiveLoginAccount;

    @ApiModelProperty(value = "审核时间")
    @TableField("RECEIVE_TIME_")
    private LocalDateTime receiveTime;

    @ApiModelProperty(value = "审批结果（1：同意 2：驳回）")
    @TableField("APPROVAL_RESULTS_")
    private Integer approvalResults;

    @ApiModelProperty(value = "审批意见描述")
    @TableField("APPROVAL_COMMENTS_")
    private String approvalComments;

    @ApiModelProperty(value = "状态（0：未结束 1：已结束）")
    @TableField("APPROVAL_STATUS_")
    private Integer approvalStatus;



}
