package com.artfess.reform.statistics.dao;

import com.artfess.reform.statistics.model.BizScoringProjectTarget;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目量化目标推进力评分结果 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-13
 */
public interface BizScoringProjectTargetDao extends BaseMapper<BizScoringProjectTarget> {

    /**
     * 根据填报年度查询所有项目的品牌显示度月度评分
     * @param fillYear 填报年
     * @param fillMonth 填报月
     * @return
     */
    List<BizScoringProjectTarget> queryMonthTargetByYearMonth(@Param("fillYear") Integer  fillYear, @Param("fillMonth") Integer  fillMonth);

    /**
     * 根据填报年度统计各项目的完成率
     * @param fillYear 填报年
     * @return
     */
    List<BizScoringProjectTarget> statisticsNum(@Param("fillYear") Integer  fillYear);

    /**
     * @Description: 查询最新的评分结果
     * @param fillYear 评比年
     * @param fillMonth 评比月
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @param projectId  项目ID
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringProjectTarget> queryLatest(@Param("fillYear") Integer fillYear, @Param("fillMonth") Integer fillMonth, @Param("fillType") String fillType, @Param("projectId") String projectId);

    /**
     * @Description: 查询最新的评分结果
     * @param fillYear 评比年
     * @param fillMonth 评比月
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringProjectTarget> queryLatestNo1(@Param("fillYear") Integer fillYear, @Param("fillMonth") Integer fillMonth, @Param("fillType") String fillType);

}
