package com.artfess.reform.statistics.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.*;
import com.artfess.reform.fill.vo.MeasureListVO;
import com.artfess.reform.fill.vo.MeasureNumVO;
import com.artfess.reform.fill.vo.MeasureTrendVO;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotMeasuresPushManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresManager;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasures;
import com.artfess.reform.statistics.dao.BizScoringProjectSynDao;
import com.artfess.reform.statistics.manager.BizScoringProjectBrandManager;
import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.statistics.model.BizScoringProjectBrand;
import com.artfess.reform.statistics.vo.ProjectSynScoreVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.statistics.manager.BizScoringProjectMeasureManager;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目具体措施推进力评分结果 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-14
 */
@RestController
@RequestMapping("/bizScoringProjectMeasure/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "项目具体措施推进力评分结果")
public class BizScoringProjectMeasureController extends BaseController<BizScoringProjectMeasureManager, BizScoringProjectMeasure> {

   @Resource
   private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;

   @Resource
   private PilotSpecificMeasuresManager pilotSpecificMeasuresManager;

   @Resource
   private PilotMeasuresPushManager pilotMeasuresPushManager;

    @GetMapping(value="/getNumVo", produces={"application/json; charset=utf-8" })
    @ApiOperation("季度评比")
    public MeasureNumVO getNumVo() {
        MeasureNumVO vo = new MeasureNumVO();
        QueryWrapper<MunicipalMajorProjectManagement> projectwrapper = new QueryWrapper<>();
        projectwrapper.eq("IS_DELE_", "0");
        projectwrapper.eq("CLOSING_", 1);
        List<MunicipalMajorProjectManagement> projects = municipalMajorProjectManagementManager.list(projectwrapper);
        int allNum = 0;
        int finishNum = 0;
        for (MunicipalMajorProjectManagement project:projects){
            QueryWrapper<PilotSpecificMeasures> scheduleQueryWrapper = new QueryWrapper<>();
            scheduleQueryWrapper.eq("STATUS_",5);
            scheduleQueryWrapper.eq("IS_DELE_","0");
            scheduleQueryWrapper.eq("PROJECT_ID_",project.getId());
//            scheduleQueryWrapper.eq("DISTRIBUTION_TYPE_",1);
            List<PilotSpecificMeasures> schedules = pilotSpecificMeasuresManager.list(scheduleQueryWrapper);
            allNum+=schedules.size();
            QueryWrapper<PilotMeasuresPush> pushQueryWrapper = new QueryWrapper<>();
            pushQueryWrapper.eq("IS_DELE_","0");
            pushQueryWrapper.eq("PROJECT_ID_",project.getId());
            pushQueryWrapper.eq("IS_OVER_",1);
            List<PilotMeasuresPush> pushes = pilotMeasuresPushManager.list(pushQueryWrapper);
            finishNum+=pushes.size();
        }
        vo.setNum(allNum);
        vo.setFinishNum(finishNum);
        if (allNum>0&&finishNum>0){
            vo.setFinishRate(new BigDecimal(finishNum).divide(new BigDecimal(allNum),2,BigDecimal.ROUND_UP));
        }else {
            vo.setFinishRate(BigDecimal.ZERO);
        }
        return vo;
    }


    public static int getSeasonDay(Date date) {
        Calendar cal = Calendar.getInstance();
        if(null != date) {
            cal.setTime(date);
        }
        int month = cal.get(Calendar.MONTH) + 1;
        return month % 3 == 0 ? month / 3 : month / 3 + 1;
    }




    @Override
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<BizScoringProjectMeasure> query(@RequestBody QueryFilter<BizScoringProjectMeasure> queryFilter) {
        SimpleDateFormat formatter= new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        QueryWrapper<BizScoringProjectMeasure> wrapper = new QueryWrapper<>();
        wrapper.orderByDesc("FILL_DATE_");
        wrapper.last("limit 1");
        BizScoringProjectMeasure projects = baseService.getOne(wrapper);
        if (projects!=null){
            queryFilter.addFilter("FILL_DATE_",df.format(projects.getFillDate()), QueryOP.EQUAL);
        }else {
            Date date = new Date(System.currentTimeMillis());
            queryFilter.addFilter("FILL_DATE_",formatter.format(date), QueryOP.EQUAL);
        }
        return super.query(queryFilter);
    }


    @PostMapping(value="/getTrend", produces={"application/json; charset=utf-8" })
    @ApiOperation("获取趋势对比")
    public MeasureTrendVO getTrend() {
        MeasureTrendVO vo = new MeasureTrendVO();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        QueryWrapper<BizScoringProjectMeasure> wrapper = new QueryWrapper<>();
        wrapper.orderByDesc("FILL_DATE_");
        wrapper.last("limit 1");
        BizScoringProjectMeasure projects = baseService.getOne(wrapper);

        QueryWrapper<BizScoringProjectMeasure> queryWrapper = new QueryWrapper<>();

        QueryWrapper<BizScoringProjectMeasure> oldWrapper = new QueryWrapper<>();
        LocalDate firstDay = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        oldWrapper.eq("FILL_DATE_",df.format(firstDay));
        if (projects!=null){
            queryWrapper.eq("FILL_DATE_",df.format(projects.getFillDate()));
        }else {
            queryWrapper.eq("FILL_DATE_",df.format(LocalDate.now()));
        }
        List<BizScoringProjectMeasure> oldlist = baseService.list(oldWrapper);
        List<BizScoringProjectMeasure> list = baseService.list(queryWrapper);
        int regimeNum = list.stream().mapToInt(BizScoringProjectMeasure::getActualRegimeNum).sum();
        int oldRegimeNum = oldlist.stream().mapToInt(BizScoringProjectMeasure::getActualRegimeNum).sum();
        vo.setRegimeNum(regimeNum);

        int appNum = list.stream().mapToInt(BizScoringProjectMeasure::getActualAppNum).sum();
        int oldAppNum = oldlist.stream().mapToInt(BizScoringProjectMeasure::getActualAppNum).sum();
        vo.setAppNum(appNum);

        int plafeormNum = list.stream().mapToInt(BizScoringProjectMeasure::getActualPlatformNum).sum();
        int oldPlafeormNum = oldlist.stream().mapToInt(BizScoringProjectMeasure::getActualPlatformNum).sum();
        vo.setPlatformNum(plafeormNum);

        if (regimeNum<oldRegimeNum){
            vo.setRegimeTrend(2);
            vo.setRegimeTrendNum(oldRegimeNum-regimeNum);
        }else if (regimeNum>oldRegimeNum){
            vo.setRegimeTrendNum(regimeNum-oldAppNum);
            vo.setRegimeTrend(1);
        }else {
            vo.setRegimeTrendNum(0);
            vo.setRegimeTrend(0);
        }

        if (appNum<oldAppNum){
            vo.setAppTrendNum(oldAppNum-appNum);
            vo.setAppTrend(2);
        }else if (appNum>oldAppNum){
            vo.setAppTrendNum(appNum-oldAppNum);
            vo.setAppTrend(1);
        }else {
            vo.setAppTrendNum(0);
            vo.setAppTrend(0);
        }

        if (plafeormNum<oldPlafeormNum){
            vo.setPlatormTrendNum(oldPlafeormNum-plafeormNum);
            vo.setPlatormTrend(2);
        }else if (plafeormNum>oldPlafeormNum){
            vo.setPlatormTrendNum(plafeormNum-oldPlafeormNum);
            vo.setPlatormTrend(1);
        }else {
            vo.setPlatormTrendNum(0);
            vo.setPlatormTrend(0);
        }
        return vo;
    }


    @PostMapping(value="/getList", produces={"application/json; charset=utf-8" })
    @ApiOperation("通过各类型分页查询")
    public IPage<MeasureListVO> getList(@RequestBody QueryFilter<BizScoringProjectMeasure> queryFilter) {
       return baseService.select4Cockpit(queryFilter);
    }

    @Resource
    private BizScoringProjectSynDao bizScoringProjectSynDao;

    @PostMapping(value="/getLists", produces={"application/json; charset=utf-8" })
    @ApiOperation("测试")
    public Map<String,ProjectSynScoreVo> getLists(@RequestParam(name = "date",required = false) LocalDate date) {
        if(date==null){
            date = LocalDate.now();
        }
        List<ProjectSynScoreVo> synList =  bizScoringProjectSynDao.statisticsSynScore(date);
        Map<String,ProjectSynScoreVo> synScoreMap = synList.stream().collect(Collectors.toMap(ProjectSynScoreVo::getProjectId, ProjectSynScoreVo -> ProjectSynScoreVo));

        return synScoreMap;
    }

    @GetMapping("/testCountScore")
    public List<BizScoringProjectMeasure> testCountScore(LocalDate countDate) {
        return baseService.countScore(countDate);
    }

}
