package com.artfess.reform.majorProjects.vo;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.artfess.file.model.DefaultFile;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectives;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 改革方案量化目标进度计划推进情况
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@ApiModel(value="PilotQuantitativeObjectivesVo对象", description="改革方案明确的量化目标集合-包含推进情况草稿")
public class PilotQuantitativeObjectivesVo extends PilotQuantitativeObjectives {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "数据ID")
    private String dataId;

    @ApiModelProperty(value = "填报ID（关联市级重大改革项目填报审核记录表ID）")
    private String fillId;

    @ApiModelProperty(value = "量化目标表ID（关联量化目标表ID）")
    private String objectivesMeasuresId;

    @ApiModelProperty(value = "当前推进值")
    private BigDecimal pushProgress;

    @ApiModelProperty(value = "推进时间")
    private LocalDate pushDate;

    @ApiModelProperty(value = "推进年份")
    private Integer pushYear;

    @ApiModelProperty(value = "推进季度")
    private Integer pushQuarter;

    @ApiModelProperty(value = "推进月度")
    private Integer pushMonth;

    @ApiModelProperty(value = "达标率")
    private BigDecimal complianceRate;

    @ApiModelProperty(value = "附件集合")
    private List<DefaultFile> defaultFileList;
}
