package com.artfess.reform.majorProjects.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 重大改革项目月度计划清单
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-03-10
 */
@Data
@ApiModel(value="PilotQuantitativeMonthPlanVo", description="重大改革项目月度计划清单")
public class PilotQuantitativeMonthPlanVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "项目ID")
    private String projectId;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "计划ID")
    private String planId;

    @ApiModelProperty(value = "计划类型")
    private Integer planType;

    @ApiModelProperty(value = "计划内容")
    private String planContent;

    @ApiModelProperty(value = "计划年")
    private Integer planYear;

    @ApiModelProperty(value = "计划月")
    private Integer planMonth;

    @ApiModelProperty(value = "填报ID")
    private String fillId;

    @ApiModelProperty(value = "填报年")
    private Integer fillYear;

    @ApiModelProperty(value = "填报月")
    private Integer fillMonth;

    @ApiModelProperty(value = "填报日期")
    private Date fillDate;

    @ApiModelProperty(value = "最新填报数据ID")
    private String pushId;

    @ApiModelProperty(value = "是否完成（0：未完成，1：已完成）")
    private String isOver;


    @ApiModelProperty(value = "已完成工作")
    private String completedWork;

    @ApiModelProperty(value = "存在问题")
    private String problems;

    @ApiModelProperty(value = "下步工作计划")
    private String workPlan;


}
