package com.artfess.reform.majorProjects.manager;

import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizMeetingDocumentsConsidered;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectives;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectivesPush;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedulePush;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 进度计划表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
public interface PilotSpecificScheduleManager extends BaseManager<PilotSpecificSchedule> {

    /**
     * 批量保存数据
     * @param entityList
     * @return
     */
    boolean saveBatch(List<PilotSpecificSchedule> entityList);

    /**
     * 根据项目ID查询数据，包含计划执行情况
     * @param projectId
     * @return
     */
    List<PilotSpecificSchedule> queryListByProjectId(String projectId);


    /**
     * 根据项目ID查询数据，不包含计划执行情况
     * @param projectId
     * @return
     */
    List<PilotSpecificSchedule> queryPilotSpecificScheduleListByProjectId(String projectId);

    /**
     * 批量导出功能
     * @param response
     * @param queryFilter
     * @throws Exception
     */
    void exportExcel(HttpServletResponse response, QueryFilter<PilotSpecificSchedule> queryFilter,boolean isAffirm) throws Exception;
}
