package com.artfess.reform.majorProjects.manager;

import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectives;
import com.artfess.base.manager.BaseManager;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 改革方案明确的量化目标表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
public interface PilotQuantitativeObjectivesManager extends BaseManager<PilotQuantitativeObjectives> {


    /**
     * 根据项目ID删除量化目标
     * @param projectId
     */
    void removeByProjectId(String projectId);

    /**
     * 批量保存量化目标信息，需要自己提前将项目ID做好关联，这里只做保存
     * @param pilotQuantitativeObjectivesList
     * @return
     */
    boolean saveBatch(List<PilotQuantitativeObjectives>  pilotQuantitativeObjectivesList);

    /**
     * 根据项目ID查询量化目标,包含了推进信息
     * @param projectId
     * @return
     */
    List<PilotQuantitativeObjectives> queryListByProjectId(String projectId);

    /**
     * 根据项目ID查询量化目标，不包含推进信息
     * @param projectId
     * @return
     */
    List<PilotQuantitativeObjectives> queryPilotQuantitativeObjectivesListByProjectId(String projectId);

    /**
     * 根据项目ID查询目标集合，同时会把最新当前年度目标值，当前月度目标值查询出来放在每一条的目标上
     * @param projectId
     * @return
     */
    List<PilotQuantitativeObjectives> queryListByProjectId(String projectId, LocalDate fillDate);
}
