package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.fill.dao.BizBlockageCardTransferDao;
import com.artfess.reform.fill.manager.BizBlockageCardTransferManager;
import com.artfess.reform.fill.manager.BizBlockageCardTransferRecordManager;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.fill.model.BizBlockageCardTransferRecord;
import com.artfess.reform.fill.vo.BlockageCardTransferVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.List;

/**
 * 堵点卡点转交办表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
@Service
public class BizBlockageCardTransferManagerImpl extends BaseManagerImpl<BizBlockageCardTransferDao, BizBlockageCardTransfer> implements BizBlockageCardTransferManager {

    @Resource
    private BizBlockageCardTransferRecordManager bizBlockageCardTransferRecordManager;
    @Resource
    private FileManager fileManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Override
    @Transactional
    public String inertInfo(BizBlockageCardTransfer blockageCard) {
        LocalDate date = LocalDate.now();
        blockageCard.setPropulsiveStatus(1);
        blockageCard.setBlockageDate(date);
        blockageCard.setBlockageYear(date.getYear());
        blockageCard.setBlockageQuarter(Integer.valueOf(date.getMonthValue() + 2) / 3);
        blockageCard.setBlockageMonth(date.getMonthValue());
        this.baseMapper.insert(blockageCard);
        return blockageCard.getId();
    }

    @Override
    @Transactional
    public CommonResult<String> deleteById(String id) {
        Assert.hasText(id,"ID不能为空！");
        if (this.records(id).size()>0){
            return new CommonResult<>(false,"已提交推进记录的交办无法删除");
        }
        this.baseMapper.deleteById(id);
        return new CommonResult<>(true,"删除成功！");
    }

    @Override
    public PageList<BizBlockageCardTransfer> queryPageList(QueryFilter<BizBlockageCardTransfer> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizBlockageCardTransfer> result=baseMapper.queryPageList(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<BizBlockageCardTransfer> queryAudit(QueryFilter<BizBlockageCardTransfer> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizBlockageCardTransfer> result=baseMapper.queryAudit(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<BizBlockageCardTransfer>(result);
    }

    @Override
    public PageList<BlockageCardTransferVo> queryBlockageCardDetailList(QueryFilter<BizBlockageCardTransfer> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BlockageCardTransferVo> result=baseMapper.queryBlockageCardDetailList(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<BlockageCardTransferVo>(result);
    }

    @Override
    @Transactional
    public boolean updatePropulsiveStatus(String id, Integer propulsiveStatus) {
        Assert.hasText(id,"ID不能为空");
        Assert.notNull(propulsiveStatus, "推进状态不能为空！");
        UpdateWrapper<BizBlockageCardTransfer> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("PROPULSIVE_STATUS_", propulsiveStatus).eq("ID_", id);
        this.baseMapper.update(null,updateWrapper);
        return true;
    }

    @Override
    public BizBlockageCardTransfer queryById(String id) {
        Assert.hasText(id,"id不能为空！");
        BizBlockageCardTransfer blockageCard = this.baseMapper.selectById(id);
        if(blockageCard!=null){
            QueryWrapper<BizBlockageCardTransferRecord> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("PROJECT_ID_",id);
            queryWrapper.orderByDesc("CREATE_TIME_");
            queryWrapper.last("LIMIT 2");
            List<BizBlockageCardTransferRecord> recordList = bizBlockageCardTransferRecordManager.list(queryWrapper);
            if(BeanUtils.isNotEmpty(recordList)){
                blockageCard.setRecords(recordList);
                for(BizBlockageCardTransferRecord record :recordList){
                    if(record.getStatus()==5){//确认完成的是历史数据
                        record.setIsHis(true);
                    }else{
                        record.setIsHis(false);
                    }
                    if(record.getStatus()==2 || record.getStatus()==4){//驳回查询驳回意见
                        AchieveStatusLog log = achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(record.getId(),record.getStatus());
                        record.setApprovalComments(log.getApprovalComments());
                    }
                    QueryWrapper<DefaultFile> fileQuery = new QueryWrapper<>();
                    fileQuery.eq("biz_id_",record.getId());
                    List<DefaultFile> filesList = fileManager.list(fileQuery);
                    record.setFiles(filesList);
                }
            }
        }
        return blockageCard;
    }

    @Override
    public List<BizBlockageCardTransferRecord> records(String projectId) {
        QueryWrapper<BizBlockageCardTransferRecord> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PROJECT_ID_",projectId);
        queryWrapper.orderByDesc("CREATE_TIME_");
        return bizBlockageCardTransferRecordManager.list(queryWrapper);
    }


    @Override
    public List<BizBlockageCardTransfer> problemSolvingDetail(String unitCode, Integer year,Integer quarter) {
        return baseMapper.problemSolvingDetail(unitCode, year,quarter);
    }
}
