package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.reform.fill.model.BizPilotAdvanceRecord;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.vo.StateVO;

import java.util.List;


public interface BizPilotAdvanceRecordManager extends BaseManager<BizPilotAdvanceRecord> {

    /**
     * 根据推进记录表id修改状态
     */
    void updateById(StateVO stateVO);

    /**
     * 批量操作-驳回
     * @param stateVO
     */
    void batchUpdateById(StateVO stateVO);

    /**
     * 保存实体类
     * @param bizPilotAdvanceRecord
     */
    String saveQuery(BizPilotAdvanceRecord bizPilotAdvanceRecord);

    /**
     * 更新实体类
     * @param bizPilotAdvanceRecord
     */
    void updateQuery(BizPilotAdvanceRecord bizPilotAdvanceRecord);

    /**
     * 查询是否存在还未完成审核的数据
     * @param id
     * @return
     */
    int countNum(String id);

    /**
     * 更新推进状态
     */
    void updatePushStatus();

    List<BizPilotAdvanceRecord> queryDeleteById(String id, String unitId);

    void editable(String pilotId,String unitId,Integer status);
}
