package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.fill.manager.BizEffectEffectivenessManager;
import com.artfess.reform.fill.model.*;
import com.artfess.reform.fill.vo.EffectDryingCompetitionExportVo;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.manager.BizEffectDryingCompetitionManager;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 成效晾晒比拼（品牌显示度） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
@RestController
@RequestMapping("/bizEffectDryingCompetition/v1/")
@Api(tags = "成效晾晒")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizEffectDryingCompetitionController extends BaseController<BizEffectDryingCompetitionManager, BizEffectDryingCompetition> {

    @Autowired
    SysDictionaryDetailManager sysDictionaryDetailManager;

    @PostMapping(value="/queryAudit", produces={"application/json; charset=utf-8" })
    @ApiOperation("成效晾晒分页查询")
    public PageList<EffectDryingCompetitionExportVo> queryAudit(@RequestBody QueryFilter<BizEffectDryingCompetition > queryFilter,@RequestParam(name = "isAffirm",required = true) Boolean isAffirm,@RequestParam(name = "status",required = false)String status) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !isAffirm) {
            queryFilter.addFilter("a.CREATE_ORG_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        if(BeanUtils.isEmpty(status)){
            sorter.add(new FieldSort("r.status_", Direction.ASC));
            sorter.add(new FieldSort("r.last_time_", Direction.DESC));
        }else {
            sorter.add(new FieldSort("t.operate_date_", Direction.ASC));
        }
        queryFilter.setSorter(sorter);
        return baseService.queryAudit(queryFilter,status);
    }

    @PostMapping(value="/queryGroup", produces={"application/json; charset=utf-8" })
    @ApiOperation("专项小组查询对应所属领域信息")
    public PageList<EffectDryingCompetitionExportVo> queryGroup(@RequestBody QueryFilter<BizEffectDryingCompetition > queryFilter,@RequestParam(name = "code",required = false)String code) {
        IUser user = ContextUtil.getCurrentUser();
        if (user.isAdmin()) {
          code=null;
        }
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("r.status_", Direction.ASC));
        sorter.add(new FieldSort("r.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return baseService.queryGroup(queryFilter,code);
    }

    @PostMapping("/inserInfo")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@RequestBody BizEffectDryingCompetition bizEffectDryingCompetition) {
        String id =  this.baseService.inertInfo(bizEffectDryingCompetition);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>(true,"成功！",id);
    }

    @PostMapping(value="/updateById")
    @ApiOperation("成效修改")
    public CommonResult<String> updateById(@RequestBody BizEffectDryingCompetition bizEffectDryingCompetition) {
        return this.baseService.updateInfo(bizEffectDryingCompetition);
    }

    @DeleteMapping("delete/{id}")
    @ApiOperation("成效根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        return this.baseService.deleteById(id);
    }

    @PostMapping("/queryById")
    @ApiOperation(value = "根据id查询交办详情与推进审批记录")
    public BizEffectDryingCompetition queryById(@RequestParam(name = "id",required = true) String id) {
        BizEffectDryingCompetition effectDryingCompetition =baseService.queryById(id);
        return effectDryingCompetition;
    }

    @PostMapping("/updateAuditStatus")
    @ApiOperation("审批状态修改")
    public CommonResult<String> updateAuditStatus(@RequestBody BizEffectEffectiveness bizEffectEffectiveness) {
        baseService.updateAuditStatus(bizEffectEffectiveness);
        return new CommonResult<String>();
    }

    
    @RequestMapping(value = "exportList", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出改革成效列表", httpMethod = "POST", notes = "导出改革成效列表")
    public void exportList(HttpServletResponse response, @ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<BizEffectDryingCompetition > queryFilter) throws Exception {
        try {
            queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
            List<FieldSort> sorter = queryFilter.getSorter();
            sorter.add(new FieldSort("r.last_time_", Direction.DESC));
            queryFilter.setSorter(sorter);
            PageList<EffectDryingCompetitionExportVo>pageList = baseService.queryAudit(queryFilter,null);
            List<Map<String, Object>> list = new ArrayList<>();
            if(BeanUtils.isNotEmpty(pageList.getRows())){
                int i=1;

                for (EffectDryingCompetitionExportVo effect : pageList.getRows()) {

                    String jsonStr = JsonUtil.toJson(effect);
                    Map<String, Object> map = JsonUtil.toMap(jsonStr);
                    //序号
                    map.put("sn",i);
                    i++;
                    //成效形式
                    if(map.get("effectForm")!=null){
                        String effectForm = map.get("effectForm").toString();
                        String effectFormText = sysDictionaryDetailManager.getTextByValue("cxxs",effectForm);
                        map.put("effectFormText",effectFormText);
                    }else{
                        map.put("effectFormText","");
                    }

                    //具体情形
                    if(map.get("specificDetails")!=null){
                        String specificDetails = map.get("specificDetails").toString();
                        String specificDetailsText = sysDictionaryDetailManager.getTextByValue("cxxs-jtqx",specificDetails);
                        map.put("specificDetailsText",specificDetailsText);
                    }else{
                        map.put("specificDetailsText","");
                    }

                    list.add(map);
                }
            }
            String tempName = "改革成效列表";
            Map<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("sn", "序号");
            exportMaps.put("effectCardTopic", "改革事情");
            exportMaps.put("completionDate", "生效日期");
            exportMaps.put("createOrgName", "填报区县");
            exportMaps.put("effectFormText", "成效形式");
            exportMaps.put("specificDetailsText", "具体情形");
            exportMaps.put("solveProblem", "解决问题");
            exportMaps.put("result", "主要成果");
            HSSFWorkbook book = ExcelUtil.exportTemplateExcel(tempName, exportMaps, list,1,"excel/effectDrying.xls");
            ExcelUtil.downloadExcel(book, tempName, response);
        } catch (Exception e) {
            throw new RuntimeException("导出失败：" + e.getMessage());
        }
    }





}
