package com.artfess.reform.statistics.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 区县满意度评分、风险扣分、综合评分结果
 *
 * @author 黎沐华
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-30
 */
@Data
@TableName("BIZ_SCORING_COUNTY_SYN")
@ApiModel(value = "BizScoringCountySyn对象", description = "区县满意度评分、风险扣分、综合评分结果")
public class BizScoringCountySyn extends BaseModel<BizScoringCountySyn> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评比日期")
    @TableField("FILL_DATE_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "评比年")
    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @ApiModelProperty(value = "评比季度")
    @TableField("FILL_QUARTER_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "评比月")
    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @ApiModelProperty(value = "评比类型（日：D，月：M，季度：Q，年：Y）")
    @TableField("FILL_TYPE_")
    private String fillType;

    @ApiModelProperty(value = "评比区县NAME（关联组织机构表NAME）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "评比区县CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "评比区县GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private Integer unitGrade;

    @ApiModelProperty(value = "社情民意电话调查满意度（%）", notes = "即满意度区县结果表BIZ_REFORM_SATISFACTION_DISTRICTS中的综合得分")
    @TableField("SATISFIED_")
    private BigDecimal satisfied = new BigDecimal(0);

    @ApiModelProperty(value = "引发重大负面舆情或群体性事件（件次）")
    @TableField("OPINION_NUM_")
    private Integer opinionNum = 0;

    @ApiModelProperty(value = "引发重大负面舆情或群体性事件（扣分）")
    @TableField("OPINION_DE_SCORE_")
    private BigDecimal opinionDeScore = new BigDecimal(0);

    @ApiModelProperty(value = "改革风险得分（总分15 减去发生事件后的扣分）")
    @TableField("OPINION_SCORE_")
    private BigDecimal opinionScore = new BigDecimal(0);

    @ApiModelProperty(value = "改革风险得分区域排名")
    @TableField("OPINION_REGION_SN_")
    private Integer opinionRegionSn=0;

    @ApiModelProperty(value = "改革风险得分全市排名")
    @TableField("OPINION_ALL_SN_")
    private Integer opinionAllSn=0;

    @ApiModelProperty(value = "社情民意电话调查满意度得分")
    @TableField("SATISFIED_SCORE_")
    private BigDecimal satisfiedScore = new BigDecimal(0);

    @ApiModelProperty(value = "社情民意电话调查满意度区域排名", notes = "即满意度区县结果表BIZ_REFORM_SATISFACTION_DISTRICTS中的区域排名")
    @TableField("SATISFIED_REGION_SN_")
    private Integer satisfiedRegionSn=0;

    @ApiModelProperty(value = "社情民意电话调查满意度全市排名", notes = "即满意度区县结果表BIZ_REFORM_SATISFACTION_DISTRICTS中的全市排名")
    @TableField("SATISFIED_ALL_SN_")
    private Integer satisfiedAllSn=0;

    @ApiModelProperty(value = "社情民意电话调查满意度全市排名档次", notes = "排名档次（A：1~9，B:10~17，C：18~25，D：26~33，E:34~41）")
    @TableField("SATISFIED_GRADE_")
    private String satisfiedGrade;

    @ApiModelProperty(value = "社情民意电话调查满意度蝉联次数", notes = "即满意度区县结果表BIZ_REFORM_SATISFACTION_DISTRICTS中的蝉联次数")
    @TableField("SATISFIED_HOLD_NUM_")
    private Integer satisfiedHoldNum;

    @ApiModelProperty(value = "综合得分", notes = "得分减去扣分后的最终结果")
    @TableField("SCORE_")
    private BigDecimal score = new BigDecimal(0);

    @ApiModelProperty(value = "综合得分全市排名档次", notes = "排名档次（A：1~9，B:10~17，C：18~25，D：26~33，E:34~41）")
    @TableField("GRADE_")
    private String grade;

    @ApiModelProperty(value = "综合得分区域排名")
    @TableField("REGION_SN_")
    private Integer regionSn;

    @ApiModelProperty(value = "综合得分全市排名")
    @TableField("ALL_SN_")
    private Integer allSn;

    @ApiModelProperty(value = "综合得分蝉联次数")
    @TableField("HOLD_NUM_")
    private Integer holdNum;

    @ApiModelProperty(value = "创建时间", hidden = true)
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "create_time_", fill = FieldFill.INSERT, select = true)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(updateStrategy = FieldStrategy.NOT_NULL, value = "LAST_TIME_", fill = FieldFill.INSERT_UPDATE, select = false)
    private Long lastTime;

    @ApiModelProperty(value = "区县序号")
    @TableField(exist = false)
    private Integer orderNo;

    @TableField(exist = false)
    @ApiModelProperty(value = "排名是否提升", notes = "相较上一季度排名是否提升")
    private Boolean promote = null;

}
