package com.artfess.reform.statistics.dao;


import com.artfess.reform.statistics.model.BizScoringCountySyn;
import com.artfess.reform.statistics.model.BizScoringProjectSyn;
import com.artfess.reform.fill.vo.SynReportVo;
import com.artfess.reform.statistics.vo.ProjectRiskScoreVo;
import com.artfess.reform.statistics.vo.ProjectSynScoreVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.List;

/**
 * 项目综合评分结果 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-13
 */
public interface BizScoringProjectSynDao extends BaseMapper<BizScoringProjectSyn> {

    /**
     * 根据填报年度查询所有项目的月度报告
     * @param fillYear 填报年
     * @param fillMonth 填报月
     * @return
     */
    List<SynReportVo> queryMonthReportByYearMonth(@Param("fillYear") Integer  fillYear, @Param("fillMonth") Integer  fillMonth);

    /**
    * @Description: 根据年月统计各个项目的扣分情况
    * @param fillYear 填报年
    * @param fillMonth  填报年
    * @Return: java.util.List<com.artfess.reform.statistics.vo.ProjectRiskScoreVo>
    * @Author: chens
    * @Date: 2023/4/1 17:39
    */
    List<ProjectRiskScoreVo> statisticsRiskScore(@Param("fillYear") Integer  fillYear,@Param("fillMonth") Integer  fillMonth);

    /**
    * @Description: 根据计算日期查询各项目的综合得分情况
    * @param fillDate  计算日期
    * @Return: java.util.List<com.artfess.reform.statistics.vo.ProjectSynScoreVo>
    * @Author: chens
    * @Date: 2023/4/1 21:08
    */
    List<ProjectSynScoreVo> statisticsSynScore(@Param("fillDate") LocalDate fillDate);

    /**
     * @Description: 查询最新的评分结果
     * @param fillYear 评比年
     * @param fillMonth 评比月
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @param projectId  项目ID
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringProjectSyn> queryLatest(@Param("fillYear") Integer fillYear, @Param("fillMonth") Integer fillMonth, @Param("fillType") String fillType, @Param("projectId") String projectId);

    /**
     * @Description: 查询最新的评分结果
     * @param fillYear 评比年
     * @param fillMonth 评比月
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringProjectSyn> queryLatestNo1(@Param("fillYear") Integer fillYear, @Param("fillMonth") Integer fillMonth, @Param("fillType") String fillType);

}
