package com.artfess.reform.majorProjects.manager.impl;


import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.reform.majorProjects.manager.BizPilotNotStartProjectFillManager;
import com.artfess.reform.majorProjects.model.BizMunicipalNotStartProjectManagement;
import com.artfess.reform.majorProjects.dao.BizMunicipalNotStartProjectManagementDao;
import com.artfess.reform.majorProjects.manager.BizMunicipalNotStartProjectManagementManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.majorProjects.model.BizPilotNotStartProjectFill;
import com.artfess.reform.majorProjects.vo.FillPushExamineVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.exception.BaseException;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;

/**
 * 市级重大改革项目(谋划储备一批和准备启动一批)管理表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-10-17
 */
@Service
public class BizMunicipalNotStartProjectManagementManagerImpl extends BaseManagerImpl<BizMunicipalNotStartProjectManagementDao, BizMunicipalNotStartProjectManagement> implements BizMunicipalNotStartProjectManagementManager {
  @Resource
  BizPilotNotStartProjectFillManager bizPilotNotStartProjectFillManager;
    @Override
    public PageList<BizMunicipalNotStartProjectManagement> queryByPage(QueryFilter<BizMunicipalNotStartProjectManagement> queryFilter, boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        queryFilter.addFilter("m.IS_DELE_","0", QueryOP.EQUAL);
        if (user!=null &&!user.isAdmin()&&!isAffirm) queryFilter.addFilter("m.UNIT_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        IPage<BizMunicipalNotStartProjectManagement> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public boolean updateById(FillPushExamineVo fillVo) {
        Assert.notNull(fillVo.getId());
        Assert.notNull(fillVo.getStatus());
        //查询是否存在已录入的数据
        QueryWrapper<BizPilotNotStartProjectFill> fillWrapper =new QueryWrapper<>();
        fillWrapper.eq("PROJECT_ID_",fillVo.getId());
        List<BizPilotNotStartProjectFill> fillList = bizPilotNotStartProjectFillManager.list(fillWrapper);
        if (BeanUtils.isNotEmpty(fillList)&&fillList.size()>0){
            throw new BaseException("已被部门填写，无法撤回!!!");
        }
        UpdateWrapper<BizMunicipalNotStartProjectManagement> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("STATUS_",fillVo.getStatus())
                .eq("ID_",fillVo.getId());
        return super.update(updateWrapper);
    }
}
