package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.model.HaiKangResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificScheduleManager;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.reform.majorProjects.vo.IterationEntityVO;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasuresHistory;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresHistoryManager;

import javax.annotation.Resource;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

/**
 * 改革方案明确的具体举措迭代历史表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@RestController
@RequestMapping("/majorProjects/pilotSpecificMeasuresHistory/v1/")
@Api(tags = "市级重大改革项目管理-改革方案明确的具体举措迭代历史")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PilotSpecificMeasuresHistoryController extends BaseController<PilotSpecificMeasuresHistoryManager, PilotSpecificMeasuresHistory> {
    @Resource
   private PilotSpecificScheduleManager pilotSpecificScheduleManager;
    /**
     * 分页查询迭代措施主页面数据
     */
    @PostMapping(value="/queryList", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询迭代措施主页面数据")
    public PageList<PilotSpecificMeasuresHistory> queryList(@RequestBody QueryFilter<PilotSpecificMeasuresHistory> queryFilter, @RequestParam(name = "isAffirm",required = true) Boolean isAffirm, @RequestParam(name = "isInput",required = true) Boolean isInput) {
        PageList<PilotSpecificMeasuresHistory> query = baseService.pageList(queryFilter,isAffirm,isInput);
        return query;
    }

    @PostMapping("/delete/{id}")
    @ApiOperation(value = "根据id删除")
    public CommonResult<String> delete(@PathVariable("id")String id){
        Assert.notNull(id,"需要删除的id不能为空");
        PilotSpecificMeasuresHistory entity = this.baseService.getById(id);
        if (entity.getStatus()>0)return new CommonResult<>(false,"无法删除,除草稿以外的数据!");

        boolean res = this.baseService.removeById(id);
        //删除月度计划表内容
        pilotSpecificScheduleManager.remove(new QueryWrapper<PilotSpecificSchedule>().eq("MEASURES_ID_",id));
        return new CommonResult<>(res?"删除成功":"删除失败");
    }

    @PostMapping("/iterateInfo")
    @ApiOperation(value = "迭代修改查询")
    public PageList<PilotSpecificMeasuresHistory> iterateInfo(@RequestBody QueryFilter<PilotSpecificMeasuresHistory> queryFilter){
        PageList<PilotSpecificMeasuresHistory> iterateInfo = this.baseService.iterateInfo(queryFilter);
            return iterateInfo;
        }

    @PostMapping("/addInfo")
    @ApiOperation(value = "迭代新增查询")
    public PageList<PilotSpecificMeasuresHistory> addInfo(@RequestBody QueryFilter<PilotSpecificMeasuresHistory> queryFilter){
        PageList<PilotSpecificMeasuresHistory> addInfo = this.baseService.addInfo(queryFilter);
        return addInfo;
    }

    @PostMapping("/auditInfo")
    @ApiOperation(value = "审核页面查询")
    public PageList<PilotSpecificMeasuresHistory> auditInfo(@RequestBody QueryFilter<PilotSpecificMeasuresHistory> queryFilter){
        PageList<PilotSpecificMeasuresHistory> auditInfo = baseService.auditInfo(queryFilter);
        return auditInfo;
    }

    @PostMapping("/findByHis/{id}")
    @ApiOperation(value = "审核页面查询")
    public List<PilotSpecificMeasuresHistory> findByHis(@PathVariable("id") String id){
        List<PilotSpecificMeasuresHistory> list = baseService.list(new QueryWrapper<PilotSpecificMeasuresHistory>()
                .eq("IS_DELE_", "0")
                .eq("SPECIFIC_MEASURES_ID_", id)
                .orderByDesc("CREATE_TIME_")
                .last("LIMIT 2"));
        return list;
    }

    @PostMapping("/ifExist/{id}")
    @ApiOperation(value = "是否存在审核中数据")
    public CommonResult<String> ifExist(@PathVariable("id") String id){
        Assert.notNull(id,"所填项目id不能为空");
        int count = baseService.count(new QueryWrapper<PilotSpecificMeasuresHistory>().eq("PROJECT_ID_", id)
                .eq("IS_DELE_", "0")
                .in("STATUS_", Arrays.asList(1, 3)));
        if (count>0) return new CommonResult<>(false,"存在审核中数据,请勿重复上报,可先保存为草稿");

        return new CommonResult<>(true,"");
    }


    @PostMapping("/ifWithdraw/{id}")
    @ApiOperation(value = "迭代后是否可以撤回")
    public CommonResult<String> ifWithdraw(@PathVariable("id") String id){
        Assert.notNull(id,"所填项目id不能为空");
        int count = baseService.count(new QueryWrapper<PilotSpecificMeasuresHistory>().eq("PROJECT_ID_", id)
                .eq("IS_DELE_", "0")
                .eq("STATUS_",1));
        if (count>0) return new CommonResult<>(false,"该项目未存在提交待审核的数据,请勿重复撤回");

        return new CommonResult<>(true,"");

    }

    @PostMapping("/deleteById")
    @ApiOperation(value = "审核页面查询")
    public CommonResult<String> deleteById(@RequestParam("id") String id,@RequestParam("isAffirm") boolean isAffirm){
        boolean res = baseService.deleteById(id, isAffirm);
        return new CommonResult<>(res?"删除成功":"删除失败");
    }
}
